/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ResourceSkusClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.ResourceSkuInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeSkuImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeResourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeSkus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ComputeSkusImpl
extends ReadableWrappersImpl<ComputeSku, ComputeSkuImpl, ResourceSkuInner>
implements ComputeSkus {
    private final ComputeManager manager;

    public ComputeSkusImpl(ComputeManager computeManager) {
        this.manager = computeManager;
    }

    @Override
    protected ComputeSkuImpl wrapModel(ResourceSkuInner inner) {
        return new ComputeSkuImpl(inner);
    }

    @Override
    public PagedIterable<ComputeSku> list() {
        return this.wrapList(this.inner().list());
    }

    @Override
    public PagedFlux<ComputeSku> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    @Override
    public PagedIterable<ComputeSku> listByRegion(String regionName) {
        return this.listByRegion(Region.fromName(regionName));
    }

    @Override
    public PagedIterable<ComputeSku> listByRegion(Region region) {
        return new PagedIterable<ComputeSku>(this.listByRegionAsync(region));
    }

    @Override
    public PagedFlux<ComputeSku> listByRegionAsync(String regionName) {
        return this.listByRegionAsync(Region.fromName(regionName));
    }

    @Override
    public PagedFlux<ComputeSku> listByRegionAsync(Region region) {
        return PagedConverter.mapPage(this.inner().listAsync(String.format("location eq '%s'", region.name()), null), this::wrapModel);
    }

    public ResourceSkusClient inner() {
        return ((ComputeManagementClient)this.manager.serviceClient()).getResourceSkus();
    }

    @Override
    public ComputeManager manager() {
        return this.manager;
    }

    @Override
    public PagedIterable<ComputeSku> listByResourceType(ComputeResourceType resourceType) {
        return new PagedIterable<ComputeSku>(this.listByResourceTypeAsync(resourceType));
    }

    @Override
    public PagedFlux<ComputeSku> listByResourceTypeAsync(ComputeResourceType resourceType) {
        return PagedConverter.flatMapPage(this.wrapPageAsync(this.inner().listAsync()), computeSku -> {
            if (computeSku.resourceType() != null && computeSku.resourceType().equals(resourceType)) {
                return Mono.just(computeSku);
            }
            return Mono.empty();
        });
    }

    @Override
    public PagedIterable<ComputeSku> listByRegionAndResourceType(Region region, ComputeResourceType resourceType) {
        return new PagedIterable<ComputeSku>(this.listByRegionAndResourceTypeAsync(region, resourceType));
    }

    @Override
    public PagedFlux<ComputeSku> listByRegionAndResourceTypeAsync(Region region, ComputeResourceType resourceType) {
        return PagedConverter.flatMapPage(this.wrapPageAsync(this.inner().listAsync(String.format("location eq '%s'", region.name()), null)), computeSku -> {
            if (computeSku.resourceType() != null && computeSku.resourceType().equals(resourceType)) {
                return Mono.just(computeSku);
            }
            return Mono.empty();
        });
    }
}

