/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryArtifactVersionFullSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersionSafetyProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.TargetRegion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class GalleryImageVersionImpl
extends CreatableUpdatableImpl<GalleryImageVersion, GalleryImageVersionInner, GalleryImageVersionImpl>
implements GalleryImageVersion,
GalleryImageVersion.Definition,
GalleryImageVersion.Update {
    private final ComputeManager manager;
    private String resourceGroupName;
    private String galleryName;
    private String galleryImageName;
    private String galleryImageVersionName;

    GalleryImageVersionImpl(String name, ComputeManager manager) {
        super(name, new GalleryImageVersionInner());
        this.manager = manager;
        this.galleryImageVersionName = name;
    }

    GalleryImageVersionImpl(GalleryImageVersionInner inner, ComputeManager manager) {
        super(inner.name(), inner);
        this.manager = manager;
        this.galleryImageVersionName = inner.name();
        this.resourceGroupName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "resourceGroups");
        this.galleryName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "galleries");
        this.galleryImageName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "images");
        this.galleryImageVersionName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "versions");
    }

    @Override
    public ComputeManager manager() {
        return this.manager;
    }

    @Override
    public Mono<GalleryImageVersion> createResourceAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName, (GalleryImageVersionInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<GalleryImageVersion> updateResourceAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName, (GalleryImageVersionInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<GalleryImageVersionInner> getInnerAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().getAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName);
    }

    @Override
    public boolean isInCreateMode() {
        return ((GalleryImageVersionInner)this.innerModel()).id() == null;
    }

    @Override
    public String id() {
        return ((GalleryImageVersionInner)this.innerModel()).id();
    }

    @Override
    public String location() {
        return ((GalleryImageVersionInner)this.innerModel()).location();
    }

    @Override
    public String name() {
        return ((GalleryImageVersionInner)this.innerModel()).name();
    }

    @Override
    public String provisioningState() {
        return ((GalleryImageVersionInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public GalleryImageVersionPublishingProfile publishingProfile() {
        return ((GalleryImageVersionInner)this.innerModel()).publishingProfile();
    }

    @Override
    public List<TargetRegion> availableRegions() {
        ArrayList<TargetRegion> regions = new ArrayList<TargetRegion>();
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() != null && ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions() != null) {
            for (TargetRegion targetRegion : ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions()) {
                regions.add(new TargetRegion().withName(targetRegion.name()).withRegionalReplicaCount(targetRegion.regionalReplicaCount()));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public OffsetDateTime endOfLifeDate() {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() != null) {
            return ((GalleryImageVersionInner)this.innerModel()).publishingProfile().endOfLifeDate();
        }
        return null;
    }

    @Override
    public Boolean isExcludedFromLatest() {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() != null) {
            return ((GalleryImageVersionInner)this.innerModel()).publishingProfile().excludeFromLatest();
        }
        return false;
    }

    @Override
    public ReplicationStatus replicationStatus() {
        return ((GalleryImageVersionInner)this.innerModel()).replicationStatus();
    }

    @Override
    public GalleryImageVersionStorageProfile storageProfile() {
        return ((GalleryImageVersionInner)this.innerModel()).storageProfile();
    }

    @Override
    public Map<String, String> tags() {
        return ((GalleryImageVersionInner)this.innerModel()).tags();
    }

    @Override
    public String type() {
        return ((GalleryImageVersionInner)this.innerModel()).type();
    }

    @Override
    public GalleryImageVersionImpl withExistingImage(String resourceGroupName, String galleryName, String galleryImageName) {
        this.resourceGroupName = resourceGroupName;
        this.galleryName = galleryName;
        this.galleryImageName = galleryImageName;
        return this;
    }

    @Override
    public GalleryImageVersionImpl withLocation(String location) {
        ((GalleryImageVersionInner)this.innerModel()).withLocation(location);
        return this;
    }

    @Override
    public GalleryImageVersion.DefinitionStages.WithSource withLocation(Region location) {
        ((GalleryImageVersionInner)this.innerModel()).withLocation(location.toString());
        return this;
    }

    @Override
    public GalleryImageVersionImpl withSourceCustomImage(String customImageId) {
        this.ensureSource();
        ((GalleryImageVersionInner)this.innerModel()).storageProfile().source().withId(customImageId);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withSourceCustomImage(VirtualMachineCustomImage customImage) {
        Objects.requireNonNull(customImage);
        return this.withSourceCustomImage(customImage.id());
    }

    @Override
    public GalleryImageVersionImpl withSourceVirtualMachine(String vmId) {
        this.ensureSource();
        ((GalleryImageVersionInner)this.innerModel()).storageProfile().source().withVirtualMachineId(vmId);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withSourceVirtualMachine(VirtualMachine virtualMachine) {
        Objects.requireNonNull(virtualMachine);
        return this.withSourceVirtualMachine(virtualMachine.id());
    }

    @Override
    public GalleryImageVersionImpl withRegionAvailability(Region region, int replicaCount) {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions() == null) {
            ((GalleryImageVersionInner)this.innerModel()).publishingProfile().withTargetRegions((List)new ArrayList());
        }
        boolean found = false;
        String newRegionName = region.toString();
        String newRegionNameTrimmed = newRegionName.replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(newRegionNameTrimmed)) continue;
            targetRegion.withRegionalReplicaCount(replicaCount);
            found = true;
            break;
        }
        if (!found) {
            TargetRegion targetRegion = new TargetRegion().withName(newRegionName).withRegionalReplicaCount(replicaCount);
            ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions().add(targetRegion);
        }
        found = false;
        String locationTrimmed = this.location().replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(locationTrimmed)) continue;
            found = true;
            break;
        }
        if (!found) {
            TargetRegion targetRegion = new TargetRegion().withName(this.location()).withRegionalReplicaCount(null);
            ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions().add(targetRegion);
        }
        return this;
    }

    @Override
    public GalleryImageVersionImpl withRegionAvailability(List<TargetRegion> targetRegions) {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)this.innerModel()).publishingProfile().withTargetRegions((List)targetRegions);
        boolean found = false;
        String locationTrimmed = this.location().replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(locationTrimmed)) continue;
            found = true;
            break;
        }
        if (!found) {
            TargetRegion defaultTargetRegion = new TargetRegion().withName(this.location()).withRegionalReplicaCount(null);
            ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions().add(defaultTargetRegion);
        }
        return this;
    }

    @Override
    public GalleryImageVersion.Update withoutRegionAvailability(Region region) {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() != null && ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions() != null) {
            int foundIndex = -1;
            int i = 0;
            String regionNameToRemove = region.toString();
            String regionNameToRemoveTrimmed = regionNameToRemove.replaceAll("\\s", "");
            for (TargetRegion targetRegion : ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions()) {
                String regionStr = targetRegion.name();
                String regionStrTrimmed = regionStr.replaceAll("\\s", "");
                if (regionStrTrimmed.equalsIgnoreCase(regionNameToRemoveTrimmed)) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((GalleryImageVersionInner)this.innerModel()).publishingProfile().targetRegions().remove(foundIndex);
                GalleryImageVersionSafetyProfile safetyProfile = ((GalleryImageVersionInner)this.innerModel()).safetyProfile();
                if (safetyProfile == null) {
                    safetyProfile = new GalleryImageVersionSafetyProfile();
                    ((GalleryImageVersionInner)this.innerModel()).withSafetyProfile(safetyProfile);
                }
                safetyProfile.withAllowDeletionOfReplicatedLocations(true);
            }
        }
        return this;
    }

    @Override
    public GalleryImageVersionImpl withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)this.innerModel()).publishingProfile().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withExcludedFromLatest() {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)this.innerModel()).publishingProfile().withExcludeFromLatest(true);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withoutExcludedFromLatest() {
        if (((GalleryImageVersionInner)this.innerModel()).publishingProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)this.innerModel()).publishingProfile().withExcludeFromLatest(false);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withTags(Map<String, String> tags) {
        ((GalleryImageVersionInner)this.innerModel()).withTags((Map)tags);
        return this;
    }

    private static String getValueFromIdByName(String id, String name) {
        if (id == null) {
            return null;
        }
        List<String> iterable = Arrays.asList(id.split("/"));
        Iterator itr = iterable.iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim().isEmpty() || !part.equalsIgnoreCase(name)) continue;
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return null;
    }

    private void ensureSource() {
        if (((GalleryImageVersionInner)this.innerModel()).storageProfile() == null) {
            ((GalleryImageVersionInner)this.innerModel()).withStorageProfile(new GalleryImageVersionStorageProfile());
        }
        if (((GalleryImageVersionInner)this.innerModel()).storageProfile().source() == null) {
            ((GalleryImageVersionInner)this.innerModel()).storageProfile().withSource(new GalleryArtifactVersionFullSource());
        }
    }
}

