/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.LinuxEncryptionExtensionUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.HashMap;
import java.util.Map;

class LinuxDiskVolumeLegacyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;

    LinuxDiskVolumeLegacyEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId(virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId(virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtension()) {
            return null;
        }
        return LinuxEncryptionExtensionUtil.progressMessage(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.osDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.dataDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return new HashMap<String, InstanceViewStatus>();
    }

    @Override
    public DiskVolumeEncryptionMonitor refresh() {
        return this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        LinuxDiskVolumeLegacyEncryptionMonitorImpl self = this;
        return this.retrieveEncryptExtensionWithInstanceViewAsync().flatMap(virtualMachineExtensionInner -> {
            this.encryptionExtension = virtualMachineExtensionInner;
            return Mono.just(self);
        }).switchIfEmpty(Mono.just(self));
    }

    private Mono<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewAsync() {
        if (this.encryptionExtension != null) {
            return this.retrieveExtensionWithInstanceViewAsync(this.encryptionExtension);
        }
        return this.retrieveEncryptExtensionWithInstanceViewFromVMAsync();
    }

    private Mono<VirtualMachineExtensionInner> retrieveExtensionWithInstanceViewAsync(VirtualMachineExtensionInner extension) {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachineExtensions().getWithResponseAsync(this.rgName, this.vmName, extension.name(), "instanceView").map(Response::getValue);
    }

    private Mono<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewFromVMAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupAsync(this.rgName, this.vmName).flatMap(virtualMachine -> {
            if (virtualMachine.resources() != null) {
                for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                    if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typePropertiesType(), OperatingSystemTypes.LINUX)) continue;
                    return this.retrieveExtensionWithInstanceViewAsync(extension);
                }
            }
            return Mono.empty();
        });
    }

    private boolean hasEncryptionExtension() {
        return this.encryptionExtension != null;
    }
}

