/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ProxyEncryptionMonitorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineEncryptionHelper;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.LinuxVMDiskEncryptionConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineEncryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.WindowsVMDiskEncryptionConfiguration;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class VirtualMachineEncryptionImpl
implements VirtualMachineEncryption {
    private final VirtualMachine virtualMachine;
    private final VirtualMachineEncryptionHelper virtualMachineEncryptionHelper;

    VirtualMachineEncryptionImpl(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.virtualMachineEncryptionHelper = new VirtualMachineEncryptionHelper(virtualMachine);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(String keyVaultId, String aadClientId, String aadSecret) {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return this.enableAsync(new LinuxVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret, ((ComputeManager)this.virtualMachine.manager()).environment()));
        }
        return this.enableAsync(new WindowsVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret, ((ComputeManager)this.virtualMachine.manager()).environment()));
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(String keyVaultId) {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return this.enableAsync(new LinuxVMDiskEncryptionConfiguration(keyVaultId, ((ComputeManager)this.virtualMachine.manager()).environment()));
        }
        return this.enableAsync(new WindowsVMDiskEncryptionConfiguration(keyVaultId, ((ComputeManager)this.virtualMachine.manager()).environment()));
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> disableAsync(DiskVolumeType volumeType) {
        return this.virtualMachineEncryptionHelper.disableEncryptionAsync(volumeType);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> getMonitorAsync() {
        return new ProxyEncryptionMonitorImpl(this.virtualMachine).refreshAsync();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(String keyVaultId, String aadClientId, String aadSecret) {
        return this.enableAsync(keyVaultId, aadClientId, aadSecret).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(String keyVaultId) {
        return this.enableAsync(keyVaultId).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return this.enableAsync(encryptionSettings).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return this.enableAsync(encryptionSettings).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor disable(DiskVolumeType volumeType) {
        return this.disableAsync(volumeType).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor getMonitor() {
        return this.getMonitorAsync().block();
    }
}

