/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionImagesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachinePublisherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachinePublisher;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachinePublishers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;

public class VirtualMachinePublishersImpl
extends ReadableWrappersImpl<VirtualMachinePublisher, VirtualMachinePublisherImpl, VirtualMachineImageResourceInner>
implements VirtualMachinePublishers {
    private final VirtualMachineImagesClient imagesClientCollection;
    private final VirtualMachineExtensionImagesClient extensionsInnerCollection;

    public VirtualMachinePublishersImpl(VirtualMachineImagesClient imagesClientCollection, VirtualMachineExtensionImagesClient extensionsInnerCollection) {
        this.imagesClientCollection = imagesClientCollection;
        this.extensionsInnerCollection = extensionsInnerCollection;
    }

    @Override
    public PagedIterable<VirtualMachinePublisher> listByRegion(Region region) {
        return this.listByRegion(region.toString());
    }

    @Override
    protected VirtualMachinePublisherImpl wrapModel(VirtualMachineImageResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualMachinePublisherImpl(Region.fromName(inner.location()), inner.name(), this.imagesClientCollection, this.extensionsInnerCollection);
    }

    @Override
    public PagedIterable<VirtualMachinePublisher> listByRegion(String regionName) {
        return new PagedIterable<VirtualMachinePublisher>(this.listByRegionAsync(regionName));
    }

    @Override
    public PagedFlux<VirtualMachinePublisher> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    @Override
    public PagedFlux<VirtualMachinePublisher> listByRegionAsync(String regionName) {
        return PagedConverter.mapPage(PagedConverter.convertListToPagedFlux(this.imagesClientCollection.listPublishersWithResponseAsync(regionName)), this::wrapModel);
    }
}

