/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class LogAnalyticsInputBase
implements JsonSerializable<LogAnalyticsInputBase> {
    private String blobContainerSasUri;
    private OffsetDateTime fromTime;
    private OffsetDateTime toTime;
    private Boolean groupByThrottlePolicy;
    private Boolean groupByOperationName;
    private Boolean groupByResourceName;
    private Boolean groupByClientApplicationId;
    private Boolean groupByUserAgent;
    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsInputBase.class);

    public String blobContainerSasUri() {
        return this.blobContainerSasUri;
    }

    public LogAnalyticsInputBase withBlobContainerSasUri(String blobContainerSasUri) {
        this.blobContainerSasUri = blobContainerSasUri;
        return this;
    }

    public OffsetDateTime fromTime() {
        return this.fromTime;
    }

    public LogAnalyticsInputBase withFromTime(OffsetDateTime fromTime) {
        this.fromTime = fromTime;
        return this;
    }

    public OffsetDateTime toTime() {
        return this.toTime;
    }

    public LogAnalyticsInputBase withToTime(OffsetDateTime toTime) {
        this.toTime = toTime;
        return this;
    }

    public Boolean groupByThrottlePolicy() {
        return this.groupByThrottlePolicy;
    }

    public LogAnalyticsInputBase withGroupByThrottlePolicy(Boolean groupByThrottlePolicy) {
        this.groupByThrottlePolicy = groupByThrottlePolicy;
        return this;
    }

    public Boolean groupByOperationName() {
        return this.groupByOperationName;
    }

    public LogAnalyticsInputBase withGroupByOperationName(Boolean groupByOperationName) {
        this.groupByOperationName = groupByOperationName;
        return this;
    }

    public Boolean groupByResourceName() {
        return this.groupByResourceName;
    }

    public LogAnalyticsInputBase withGroupByResourceName(Boolean groupByResourceName) {
        this.groupByResourceName = groupByResourceName;
        return this;
    }

    public Boolean groupByClientApplicationId() {
        return this.groupByClientApplicationId;
    }

    public LogAnalyticsInputBase withGroupByClientApplicationId(Boolean groupByClientApplicationId) {
        this.groupByClientApplicationId = groupByClientApplicationId;
        return this;
    }

    public Boolean groupByUserAgent() {
        return this.groupByUserAgent;
    }

    public LogAnalyticsInputBase withGroupByUserAgent(Boolean groupByUserAgent) {
        this.groupByUserAgent = groupByUserAgent;
        return this;
    }

    public void validate() {
        if (this.blobContainerSasUri() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property blobContainerSasUri in model LogAnalyticsInputBase"));
        }
        if (this.fromTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property fromTime in model LogAnalyticsInputBase"));
        }
        if (this.toTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property toTime in model LogAnalyticsInputBase"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobContainerSasUri", this.blobContainerSasUri);
        jsonWriter.writeStringField("fromTime", this.fromTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.fromTime));
        jsonWriter.writeStringField("toTime", this.toTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.toTime));
        jsonWriter.writeBooleanField("groupByThrottlePolicy", this.groupByThrottlePolicy);
        jsonWriter.writeBooleanField("groupByOperationName", this.groupByOperationName);
        jsonWriter.writeBooleanField("groupByResourceName", this.groupByResourceName);
        jsonWriter.writeBooleanField("groupByClientApplicationId", this.groupByClientApplicationId);
        jsonWriter.writeBooleanField("groupByUserAgent", this.groupByUserAgent);
        return jsonWriter.writeEndObject();
    }

    public static LogAnalyticsInputBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalyticsInputBase deserializedLogAnalyticsInputBase = new LogAnalyticsInputBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobContainerSasUri".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.blobContainerSasUri = reader.getString();
                    continue;
                }
                if ("fromTime".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.fromTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("toTime".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.toTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("groupByThrottlePolicy".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.groupByThrottlePolicy = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("groupByOperationName".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.groupByOperationName = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("groupByResourceName".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.groupByResourceName = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("groupByClientApplicationId".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.groupByClientApplicationId = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("groupByUserAgent".equals(fieldName)) {
                    deserializedLogAnalyticsInputBase.groupByUserAgent = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogAnalyticsInputBase;
        });
    }
}

