/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HostEndpointSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Mode;
import java.io.IOException;

public final class ProxyAgentSettings
implements JsonSerializable<ProxyAgentSettings> {
    private Boolean enabled;
    private Mode mode;
    private Integer keyIncarnationId;
    private HostEndpointSettings wireServer;
    private HostEndpointSettings imds;

    public Boolean enabled() {
        return this.enabled;
    }

    public ProxyAgentSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    public ProxyAgentSettings withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Integer keyIncarnationId() {
        return this.keyIncarnationId;
    }

    public ProxyAgentSettings withKeyIncarnationId(Integer keyIncarnationId) {
        this.keyIncarnationId = keyIncarnationId;
        return this;
    }

    public HostEndpointSettings wireServer() {
        return this.wireServer;
    }

    public ProxyAgentSettings withWireServer(HostEndpointSettings wireServer) {
        this.wireServer = wireServer;
        return this;
    }

    public HostEndpointSettings imds() {
        return this.imds;
    }

    public ProxyAgentSettings withImds(HostEndpointSettings imds) {
        this.imds = imds;
        return this;
    }

    public void validate() {
        if (this.wireServer() != null) {
            this.wireServer().validate();
        }
        if (this.imds() != null) {
            this.imds().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeNumberField("keyIncarnationId", this.keyIncarnationId);
        jsonWriter.writeJsonField("wireServer", this.wireServer);
        jsonWriter.writeJsonField("imds", this.imds);
        return jsonWriter.writeEndObject();
    }

    public static ProxyAgentSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProxyAgentSettings deserializedProxyAgentSettings = new ProxyAgentSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedProxyAgentSettings.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedProxyAgentSettings.mode = Mode.fromString(reader.getString());
                    continue;
                }
                if ("keyIncarnationId".equals(fieldName)) {
                    deserializedProxyAgentSettings.keyIncarnationId = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("wireServer".equals(fieldName)) {
                    deserializedProxyAgentSettings.wireServer = HostEndpointSettings.fromJson(reader);
                    continue;
                }
                if ("imds".equals(fieldName)) {
                    deserializedProxyAgentSettings.imds = HostEndpointSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProxyAgentSettings;
        });
    }
}

