/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.IntervalInMins;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.LogAnalyticsInputBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RequestRateByIntervalInput
extends LogAnalyticsInputBase {
    private IntervalInMins intervalLength;
    private static final ClientLogger LOGGER = new ClientLogger(RequestRateByIntervalInput.class);

    public IntervalInMins intervalLength() {
        return this.intervalLength;
    }

    public RequestRateByIntervalInput withIntervalLength(IntervalInMins intervalLength) {
        this.intervalLength = intervalLength;
        return this;
    }

    @Override
    public RequestRateByIntervalInput withBlobContainerSasUri(String blobContainerSasUri) {
        super.withBlobContainerSasUri(blobContainerSasUri);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withFromTime(OffsetDateTime fromTime) {
        super.withFromTime(fromTime);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withToTime(OffsetDateTime toTime) {
        super.withToTime(toTime);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withGroupByThrottlePolicy(Boolean groupByThrottlePolicy) {
        super.withGroupByThrottlePolicy(groupByThrottlePolicy);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withGroupByOperationName(Boolean groupByOperationName) {
        super.withGroupByOperationName(groupByOperationName);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withGroupByResourceName(Boolean groupByResourceName) {
        super.withGroupByResourceName(groupByResourceName);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withGroupByClientApplicationId(Boolean groupByClientApplicationId) {
        super.withGroupByClientApplicationId(groupByClientApplicationId);
        return this;
    }

    @Override
    public RequestRateByIntervalInput withGroupByUserAgent(Boolean groupByUserAgent) {
        super.withGroupByUserAgent(groupByUserAgent);
        return this;
    }

    @Override
    public void validate() {
        if (this.intervalLength() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property intervalLength in model RequestRateByIntervalInput"));
        }
        if (this.blobContainerSasUri() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property blobContainerSasUri in model RequestRateByIntervalInput"));
        }
        if (this.fromTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property fromTime in model RequestRateByIntervalInput"));
        }
        if (this.toTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property toTime in model RequestRateByIntervalInput"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobContainerSasUri", this.blobContainerSasUri());
        jsonWriter.writeStringField("fromTime", this.fromTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.fromTime()));
        jsonWriter.writeStringField("toTime", this.toTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.toTime()));
        jsonWriter.writeBooleanField("groupByThrottlePolicy", this.groupByThrottlePolicy());
        jsonWriter.writeBooleanField("groupByOperationName", this.groupByOperationName());
        jsonWriter.writeBooleanField("groupByResourceName", this.groupByResourceName());
        jsonWriter.writeBooleanField("groupByClientApplicationId", this.groupByClientApplicationId());
        jsonWriter.writeBooleanField("groupByUserAgent", this.groupByUserAgent());
        jsonWriter.writeStringField("intervalLength", this.intervalLength == null ? null : this.intervalLength.toString());
        return jsonWriter.writeEndObject();
    }

    public static RequestRateByIntervalInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestRateByIntervalInput deserializedRequestRateByIntervalInput = new RequestRateByIntervalInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobContainerSasUri".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withBlobContainerSasUri(reader.getString());
                    continue;
                }
                if ("fromTime".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withFromTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("toTime".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withToTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("groupByThrottlePolicy".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withGroupByThrottlePolicy(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByOperationName".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withGroupByOperationName(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByResourceName".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withGroupByResourceName(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByClientApplicationId".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withGroupByClientApplicationId(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByUserAgent".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withGroupByUserAgent(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("intervalLength".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.intervalLength = IntervalInMins.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestRateByIntervalInput;
        });
    }
}

