/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ExecutionState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class VirtualMachineRunCommandInstanceView
implements JsonSerializable<VirtualMachineRunCommandInstanceView> {
    private ExecutionState executionState;
    private String executionMessage;
    private Integer exitCode;
    private String output;
    private String error;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<InstanceViewStatus> statuses;

    public ExecutionState executionState() {
        return this.executionState;
    }

    public VirtualMachineRunCommandInstanceView withExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
        return this;
    }

    public String executionMessage() {
        return this.executionMessage;
    }

    public VirtualMachineRunCommandInstanceView withExecutionMessage(String executionMessage) {
        this.executionMessage = executionMessage;
        return this;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public VirtualMachineRunCommandInstanceView withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public String output() {
        return this.output;
    }

    public VirtualMachineRunCommandInstanceView withOutput(String output) {
        this.output = output;
        return this;
    }

    public String error() {
        return this.error;
    }

    public VirtualMachineRunCommandInstanceView withError(String error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public VirtualMachineRunCommandInstanceView withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public VirtualMachineRunCommandInstanceView withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineRunCommandInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("executionState", this.executionState == null ? null : this.executionState.toString());
        jsonWriter.writeStringField("executionMessage", this.executionMessage);
        jsonWriter.writeNumberField("exitCode", this.exitCode);
        jsonWriter.writeStringField("output", this.output);
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineRunCommandInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineRunCommandInstanceView deserializedVirtualMachineRunCommandInstanceView = new VirtualMachineRunCommandInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("executionState".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.executionState = ExecutionState.fromString(reader.getString());
                    continue;
                }
                if ("executionMessage".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.executionMessage = reader.getString();
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.exitCode = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.output = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.error = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInstanceView.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedVirtualMachineRunCommandInstanceView.statuses = statuses;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineRunCommandInstanceView;
        });
    }
}

