/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ConfidentialComputeProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Container;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupPriority;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.DeploymentExtensionSpec;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Volume;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ContainerGroupInner
extends Resource {
    private List<String> zones;
    private ContainerGroupIdentity identity;
    private ContainerGroupProperties innerProperties = new ContainerGroupProperties();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupInner.class);

    public List<String> zones() {
        return this.zones;
    }

    public ContainerGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ContainerGroupIdentity identity() {
        return this.identity;
    }

    public ContainerGroupInner withIdentity(ContainerGroupIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ContainerGroupProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ContainerGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ContainerGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<Container> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    public ContainerGroupInner withContainers(List<Container> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().imageRegistryCredentials();
    }

    public ContainerGroupInner withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withImageRegistryCredentials(imageRegistryCredentials);
        return this;
    }

    public ContainerGroupRestartPolicy restartPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().restartPolicy();
    }

    public ContainerGroupInner withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withRestartPolicy(restartPolicy);
        return this;
    }

    public IpAddress ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public ContainerGroupInner withIpAddress(IpAddress ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public ContainerGroupInner withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public List<Volume> volumes() {
        return this.innerProperties() == null ? null : this.innerProperties().volumes();
    }

    public ContainerGroupInner withVolumes(List<Volume> volumes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withVolumes(volumes);
        return this;
    }

    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public ContainerGroupDiagnostics diagnostics() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnostics();
    }

    public ContainerGroupInner withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDiagnostics(diagnostics);
        return this;
    }

    public List<ContainerGroupSubnetId> subnetIds() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetIds();
    }

    public ContainerGroupInner withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSubnetIds(subnetIds);
        return this;
    }

    public DnsConfiguration dnsConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsConfig();
    }

    public ContainerGroupInner withDnsConfig(DnsConfiguration dnsConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDnsConfig(dnsConfig);
        return this;
    }

    public ContainerGroupSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ContainerGroupInner withSku(ContainerGroupSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionProperties();
    }

    public ContainerGroupInner withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withEncryptionProperties(encryptionProperties);
        return this;
    }

    public List<InitContainerDefinition> initContainers() {
        return this.innerProperties() == null ? null : this.innerProperties().initContainers();
    }

    public ContainerGroupInner withInitContainers(List<InitContainerDefinition> initContainers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withInitContainers(initContainers);
        return this;
    }

    public List<DeploymentExtensionSpec> extensions() {
        return this.innerProperties() == null ? null : this.innerProperties().extensions();
    }

    public ContainerGroupInner withExtensions(List<DeploymentExtensionSpec> extensions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withExtensions(extensions);
        return this;
    }

    public ConfidentialComputeProperties confidentialComputeProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().confidentialComputeProperties();
    }

    public ContainerGroupInner withConfidentialComputeProperties(ConfidentialComputeProperties confidentialComputeProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withConfidentialComputeProperties(confidentialComputeProperties);
        return this;
    }

    public ContainerGroupPriority priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public ContainerGroupInner withPriority(ContainerGroupPriority priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model ContainerGroupInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ContainerGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupInner deserializedContainerGroupInner = new ContainerGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedContainerGroupInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerGroupInner.innerProperties = ContainerGroupProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerGroupInner.zones = zones;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedContainerGroupInner.identity = ContainerGroupIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerGroupInner;
        });
    }
}

