/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.ContainerProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerProbe;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerPropertiesInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class Container
implements JsonSerializable<Container> {
    private String name;
    private ContainerProperties innerProperties = new ContainerProperties();
    private static final ClientLogger LOGGER = new ClientLogger(Container.class);

    public String name() {
        return this.name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    private ContainerProperties innerProperties() {
        return this.innerProperties;
    }

    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    public Container withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    public List<String> command() {
        return this.innerProperties() == null ? null : this.innerProperties().command();
    }

    public Container withCommand(List<String> command) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withCommand(command);
        return this;
    }

    public List<ContainerPort> ports() {
        return this.innerProperties() == null ? null : this.innerProperties().ports();
    }

    public Container withPorts(List<ContainerPort> ports) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withPorts(ports);
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public Container withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    public ContainerPropertiesInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public ResourceRequirements resources() {
        return this.innerProperties() == null ? null : this.innerProperties().resources();
    }

    public Container withResources(ResourceRequirements resources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withResources(resources);
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    public Container withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    public ContainerProbe livenessProbe() {
        return this.innerProperties() == null ? null : this.innerProperties().livenessProbe();
    }

    public Container withLivenessProbe(ContainerProbe livenessProbe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withLivenessProbe(livenessProbe);
        return this;
    }

    public ContainerProbe readinessProbe() {
        return this.innerProperties() == null ? null : this.innerProperties().readinessProbe();
    }

    public Container withReadinessProbe(ContainerProbe readinessProbe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withReadinessProbe(readinessProbe);
        return this;
    }

    public SecurityContextDefinition securityContext() {
        return this.innerProperties() == null ? null : this.innerProperties().securityContext();
    }

    public Container withSecurityContext(SecurityContextDefinition securityContext) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withSecurityContext(securityContext);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Container"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model Container"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static Container fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Container deserializedContainer = new Container();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedContainer.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainer.innerProperties = ContainerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainer;
        });
    }
}

