/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Argument;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Credentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RunRequest;
import java.io.IOException;
import java.util.List;

public final class DockerBuildRequest
extends RunRequest {
    private String type = "DockerBuildRequest";
    private List<String> imageNames;
    private Boolean isPushEnabled;
    private Boolean noCache;
    private String dockerFilePath;
    private String target;
    private List<Argument> arguments;
    private Integer timeout;
    private PlatformProperties platform;
    private AgentProperties agentConfiguration;
    private String sourceLocation;
    private Credentials credentials;
    private static final ClientLogger LOGGER = new ClientLogger(DockerBuildRequest.class);

    @Override
    public String type() {
        return this.type;
    }

    public List<String> imageNames() {
        return this.imageNames;
    }

    public DockerBuildRequest withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    public DockerBuildRequest withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    public Boolean noCache() {
        return this.noCache;
    }

    public DockerBuildRequest withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    public DockerBuildRequest withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    public String target() {
        return this.target;
    }

    public DockerBuildRequest withTarget(String target) {
        this.target = target;
        return this;
    }

    public List<Argument> arguments() {
        return this.arguments;
    }

    public DockerBuildRequest withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public DockerBuildRequest withTimeout(Integer timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public DockerBuildRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public DockerBuildRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public DockerBuildRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public DockerBuildRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public DockerBuildRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public DockerBuildRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public DockerBuildRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.dockerFilePath() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property dockerFilePath in model DockerBuildRequest"));
        }
        if (this.arguments() != null) {
            this.arguments().forEach(e -> e.validate());
        }
        if (this.platform() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property platform in model DockerBuildRequest"));
        }
        this.platform().validate();
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled());
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName());
        jsonWriter.writeStringField("logTemplate", this.logTemplate());
        jsonWriter.writeStringField("dockerFilePath", this.dockerFilePath);
        jsonWriter.writeJsonField("platform", this.platform);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("imageNames", this.imageNames, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("isPushEnabled", this.isPushEnabled);
        jsonWriter.writeBooleanField("noCache", this.noCache);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeJsonField("agentConfiguration", this.agentConfiguration);
        jsonWriter.writeStringField("sourceLocation", this.sourceLocation);
        jsonWriter.writeJsonField("credentials", this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static DockerBuildRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DockerBuildRequest deserializedDockerBuildRequest = new DockerBuildRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedDockerBuildRequest.withIsArchiveEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedDockerBuildRequest.withAgentPoolName(reader.getString());
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedDockerBuildRequest.withLogTemplate(reader.getString());
                    continue;
                }
                if ("dockerFilePath".equals(fieldName)) {
                    deserializedDockerBuildRequest.dockerFilePath = reader.getString();
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedDockerBuildRequest.platform = PlatformProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDockerBuildRequest.type = reader.getString();
                    continue;
                }
                if ("imageNames".equals(fieldName)) {
                    List<String> imageNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedDockerBuildRequest.imageNames = imageNames;
                    continue;
                }
                if ("isPushEnabled".equals(fieldName)) {
                    deserializedDockerBuildRequest.isPushEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("noCache".equals(fieldName)) {
                    deserializedDockerBuildRequest.noCache = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedDockerBuildRequest.target = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List<Argument> arguments = reader.readArray(reader1 -> Argument.fromJson(reader1));
                    deserializedDockerBuildRequest.arguments = arguments;
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedDockerBuildRequest.timeout = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("agentConfiguration".equals(fieldName)) {
                    deserializedDockerBuildRequest.agentConfiguration = AgentProperties.fromJson(reader);
                    continue;
                }
                if ("sourceLocation".equals(fieldName)) {
                    deserializedDockerBuildRequest.sourceLocation = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedDockerBuildRequest.credentials = Credentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDockerBuildRequest;
        });
    }
}

