/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Argument;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.StepType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import java.io.IOException;
import java.util.List;

public final class DockerTaskStep
extends TaskStepProperties {
    private StepType type = StepType.DOCKER;
    private List<String> imageNames;
    private Boolean isPushEnabled;
    private Boolean noCache;
    private String dockerFilePath;
    private String target;
    private List<Argument> arguments;
    private List<BaseImageDependency> baseImageDependencies;
    private static final ClientLogger LOGGER = new ClientLogger(DockerTaskStep.class);

    @Override
    public StepType type() {
        return this.type;
    }

    public List<String> imageNames() {
        return this.imageNames;
    }

    public DockerTaskStep withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    public DockerTaskStep withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    public Boolean noCache() {
        return this.noCache;
    }

    public DockerTaskStep withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    public DockerTaskStep withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    public String target() {
        return this.target;
    }

    public DockerTaskStep withTarget(String target) {
        this.target = target;
        return this;
    }

    public List<Argument> arguments() {
        return this.arguments;
    }

    public DockerTaskStep withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    @Override
    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    @Override
    public DockerTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public DockerTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.dockerFilePath() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property dockerFilePath in model DockerTaskStep"));
        }
        if (this.arguments() != null) {
            this.arguments().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("dockerFilePath", this.dockerFilePath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("imageNames", this.imageNames, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("isPushEnabled", this.isPushEnabled);
        jsonWriter.writeBooleanField("noCache", this.noCache);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static DockerTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DockerTaskStep deserializedDockerTaskStep = new DockerTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedDockerTaskStep.baseImageDependencies = baseImageDependencies;
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedDockerTaskStep.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedDockerTaskStep.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("dockerFilePath".equals(fieldName)) {
                    deserializedDockerTaskStep.dockerFilePath = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDockerTaskStep.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("imageNames".equals(fieldName)) {
                    List<String> imageNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedDockerTaskStep.imageNames = imageNames;
                    continue;
                }
                if ("isPushEnabled".equals(fieldName)) {
                    deserializedDockerTaskStep.isPushEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("noCache".equals(fieldName)) {
                    deserializedDockerTaskStep.noCache = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedDockerTaskStep.target = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List<Argument> arguments = reader.readArray(reader1 -> Argument.fromJson(reader1));
                    deserializedDockerTaskStep.arguments = arguments;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDockerTaskStep;
        });
    }
}

