/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.EventContent;
import java.io.IOException;
import java.util.Map;

public final class EventRequestMessage
implements JsonSerializable<EventRequestMessage> {
    private EventContent content;
    private Map<String, String> headers;
    private String method;
    private String requestUri;
    private String version;

    public EventContent content() {
        return this.content;
    }

    public EventRequestMessage withContent(EventContent content) {
        this.content = content;
        return this;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public EventRequestMessage withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String method() {
        return this.method;
    }

    public EventRequestMessage withMethod(String method) {
        this.method = method;
        return this;
    }

    public String requestUri() {
        return this.requestUri;
    }

    public EventRequestMessage withRequestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    public String version() {
        return this.version;
    }

    public EventRequestMessage withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.content() != null) {
            this.content().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("content", this.content);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("requestUri", this.requestUri);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static EventRequestMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventRequestMessage deserializedEventRequestMessage = new EventRequestMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    deserializedEventRequestMessage.content = EventContent.fromJson(reader);
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map<String, String> headers = reader.readMap(reader1 -> reader1.getString());
                    deserializedEventRequestMessage.headers = headers;
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedEventRequestMessage.method = reader.getString();
                    continue;
                }
                if ("requestUri".equals(fieldName)) {
                    deserializedEventRequestMessage.requestUri = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedEventRequestMessage.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventRequestMessage;
        });
    }
}

