/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.DefaultAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.IpRule;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSet
implements JsonSerializable<NetworkRuleSet> {
    private DefaultAction defaultAction;
    private List<IpRule> ipRules;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkRuleSet.class);

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public void validate() {
        if (this.defaultAction() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property defaultAction in model NetworkRuleSet"));
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkRuleSet deserializedNetworkRuleSet = new NetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultAction".equals(fieldName)) {
                    deserializedNetworkRuleSet.defaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List<IpRule> ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    deserializedNetworkRuleSet.ipRules = ipRules;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSet;
        });
    }
}

