/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TokenPasswordName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TokenPassword
implements JsonSerializable<TokenPassword> {
    private OffsetDateTime creationTime;
    private OffsetDateTime expiry;
    private TokenPasswordName name;
    private String value;

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public TokenPassword withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public TokenPassword withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public TokenPasswordName name() {
        return this.name;
    }

    public TokenPassword withName(TokenPasswordName name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static TokenPassword fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenPassword deserializedTokenPassword = new TokenPassword();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedTokenPassword.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedTokenPassword.expiry = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTokenPassword.name = TokenPasswordName.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedTokenPassword.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenPassword;
        });
    }
}

