/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.TrustedAccessRoleBindingProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TrustedAccessRoleBindingProperties
implements JsonSerializable<TrustedAccessRoleBindingProperties> {
    private TrustedAccessRoleBindingProvisioningState provisioningState;
    private String sourceResourceId;
    private List<String> roles;
    private static final ClientLogger LOGGER = new ClientLogger(TrustedAccessRoleBindingProperties.class);

    public TrustedAccessRoleBindingProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public TrustedAccessRoleBindingProperties withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public List<String> roles() {
        return this.roles;
    }

    public TrustedAccessRoleBindingProperties withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public void validate() {
        if (this.sourceResourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceResourceId in model TrustedAccessRoleBindingProperties"));
        }
        if (this.roles() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property roles in model TrustedAccessRoleBindingProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static TrustedAccessRoleBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrustedAccessRoleBindingProperties deserializedTrustedAccessRoleBindingProperties = new TrustedAccessRoleBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingProperties.sourceResourceId = reader.getString();
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List<String> roles = reader.readArray(reader1 -> reader1.getString());
                    deserializedTrustedAccessRoleBindingProperties.roles = roles;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingProperties.provisioningState = TrustedAccessRoleBindingProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrustedAccessRoleBindingProperties;
        });
    }
}

