/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MetricName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PercentileMetricValue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PercentileMetricInner
implements JsonSerializable<PercentileMetricInner> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String timeGrain;
    private UnitType unit;
    private MetricName name;
    private List<PercentileMetricValue> metricValues;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String timeGrain() {
        return this.timeGrain;
    }

    public UnitType unit() {
        return this.unit;
    }

    public MetricName name() {
        return this.name;
    }

    public List<PercentileMetricValue> metricValues() {
        return this.metricValues;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
        if (this.metricValues() != null) {
            this.metricValues().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PercentileMetricInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PercentileMetricInner deserializedPercentileMetricInner = new PercentileMetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedPercentileMetricInner.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedPercentileMetricInner.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedPercentileMetricInner.timeGrain = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedPercentileMetricInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPercentileMetricInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("metricValues".equals(fieldName)) {
                    List<PercentileMetricValue> metricValues = reader.readArray(reader1 -> PercentileMetricValue.fromJson(reader1));
                    deserializedPercentileMetricInner.metricValues = metricValues;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPercentileMetricInner;
        });
    }
}

