/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class CommandPostBody
implements JsonSerializable<CommandPostBody> {
    private String command;
    private Map<String, String> arguments;
    private String host;
    private Boolean cassandraStopStart;
    private Boolean readwrite;
    private static final ClientLogger LOGGER = new ClientLogger(CommandPostBody.class);

    public String command() {
        return this.command;
    }

    public CommandPostBody withCommand(String command) {
        this.command = command;
        return this;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public CommandPostBody withArguments(Map<String, String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String host() {
        return this.host;
    }

    public CommandPostBody withHost(String host) {
        this.host = host;
        return this;
    }

    public Boolean cassandraStopStart() {
        return this.cassandraStopStart;
    }

    public CommandPostBody withCassandraStopStart(Boolean cassandraStopStart) {
        this.cassandraStopStart = cassandraStopStart;
        return this;
    }

    public Boolean readwrite() {
        return this.readwrite;
    }

    public CommandPostBody withReadwrite(Boolean readwrite) {
        this.readwrite = readwrite;
        return this;
    }

    public void validate() {
        if (this.command() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property command in model CommandPostBody"));
        }
        if (this.host() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property host in model CommandPostBody"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("command", this.command);
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeMapField("arguments", this.arguments, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("cassandra-stop-start", this.cassandraStopStart);
        jsonWriter.writeBooleanField("readwrite", this.readwrite);
        return jsonWriter.writeEndObject();
    }

    public static CommandPostBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommandPostBody deserializedCommandPostBody = new CommandPostBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("command".equals(fieldName)) {
                    deserializedCommandPostBody.command = reader.getString();
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedCommandPostBody.host = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    Map<String, String> arguments = reader.readMap(reader1 -> reader1.getString());
                    deserializedCommandPostBody.arguments = arguments;
                    continue;
                }
                if ("cassandra-stop-start".equals(fieldName)) {
                    deserializedCommandPostBody.cassandraStopStart = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("readwrite".equals(fieldName)) {
                    deserializedCommandPostBody.readwrite = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommandPostBody;
        });
    }
}

