/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ClientEncryptionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ComputedProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SqlContainerResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.VectorEmbeddingPolicy;
import java.io.IOException;
import java.util.List;

public final class SqlContainerGetPropertiesResource
extends SqlContainerResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SqlContainerGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        super.withClientEncryptionPolicy(clientEncryptionPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withComputedProperties(List<ComputedProperty> computedProperties) {
        super.withComputedProperties(computedProperties);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withVectorEmbeddingPolicy(VectorEmbeddingPolicy vectorEmbeddingPolicy) {
        super.withVectorEmbeddingPolicy(vectorEmbeddingPolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model SqlContainerGetPropertiesResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.clientEncryptionPolicy() != null) {
            this.clientEncryptionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.computedProperties() != null) {
            this.computedProperties().forEach(e -> e.validate());
        }
        if (this.vectorEmbeddingPolicy() != null) {
            this.vectorEmbeddingPolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("indexingPolicy", this.indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", this.partitionKey());
        jsonWriter.writeNumberField("defaultTtl", this.defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", this.uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", this.conflictResolutionPolicy());
        jsonWriter.writeJsonField("clientEncryptionPolicy", this.clientEncryptionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        jsonWriter.writeArrayField("computedProperties", this.computedProperties(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("vectorEmbeddingPolicy", this.vectorEmbeddingPolicy());
        return jsonWriter.writeEndObject();
    }

    public static SqlContainerGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlContainerGetPropertiesResource deserializedSqlContainerGetPropertiesResource = new SqlContainerGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withPartitionKey(ContainerPartitionKey.fromJson(reader));
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withDefaultTtl(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                    continue;
                }
                if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withClientEncryptionPolicy(ClientEncryptionPolicy.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withAnalyticalStorageTtl(reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("computedProperties".equals(fieldName)) {
                    List<ComputedProperty> computedProperties = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedSqlContainerGetPropertiesResource.withComputedProperties((List)computedProperties);
                    continue;
                }
                if ("vectorEmbeddingPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withVectorEmbeddingPolicy(VectorEmbeddingPolicy.fromJson(reader));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlContainerGetPropertiesResource;
        });
    }
}

