/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import java.io.IOException;

public class TableResource
implements JsonSerializable<TableResource> {
    private String id;
    private ResourceRestoreParameters restoreParameters;
    private CreateMode createMode;
    private static final ClientLogger LOGGER = new ClientLogger(TableResource.class);

    public String id() {
        return this.id;
    }

    public TableResource withId(String id) {
        this.id = id;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public TableResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public TableResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model TableResource"));
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static TableResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableResource deserializedTableResource = new TableResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableResource.id = reader.getString();
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedTableResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedTableResource.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableResource;
        });
    }
}

