/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.VectorIndexType;
import java.io.IOException;

public final class VectorIndex
implements JsonSerializable<VectorIndex> {
    private String path;
    private VectorIndexType type;
    private static final ClientLogger LOGGER = new ClientLogger(VectorIndex.class);

    public String path() {
        return this.path;
    }

    public VectorIndex withPath(String path) {
        this.path = path;
        return this;
    }

    public VectorIndexType type() {
        return this.type;
    }

    public VectorIndex withType(VectorIndexType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property path in model VectorIndex"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model VectorIndex"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorIndex fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorIndex deserializedVectorIndex = new VectorIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedVectorIndex.path = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVectorIndex.type = VectorIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorIndex;
        });
    }
}

