/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsZonesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZones;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class DnsZoneManager
extends Manager<DnsManagementClient> {
    private DnsZones zones;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static DnsZoneManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DnsZoneManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static DnsZoneManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DnsZoneManager(httpPipeline, profile);
    }

    private DnsZoneManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new DnsManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public DnsZones zones() {
        if (this.zones == null) {
            this.zones = new DnsZonesImpl(this);
        }
        return this.zones;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public DnsZoneManager authenticate(TokenCredential credential, AzureProfile profile) {
            return DnsZoneManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public DnsZoneManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

