/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.ApplicationGroupsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.ApplicationGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.ApplicationGroupListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ApplicationGroupsClientImpl
implements ApplicationGroupsClient {
    private final ApplicationGroupsService service;
    private final EventHubManagementClientImpl client;

    ApplicationGroupsClientImpl(EventHubManagementClientImpl client) {
        this.service = RestProxy.create(ApplicationGroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationGroupInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespace(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationGroupInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGroupListResult)res.getValue()).value(), ((ApplicationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationGroupInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespace(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationGroupInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGroupListResult)res.getValue()).value(), ((ApplicationGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationGroupInner> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return new PagedFlux<ApplicationGroupInner>(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApplicationGroupInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, Context context) {
        return new PagedFlux<ApplicationGroupInner>(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, context), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationGroupInner> listByNamespace(String resourceGroupName, String namespaceName) {
        return new PagedIterable<ApplicationGroupInner>(this.listByNamespaceAsync(resourceGroupName, namespaceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationGroupInner> listByNamespace(String resourceGroupName, String namespaceName, Context context) {
        return new PagedIterable<ApplicationGroupInner>(this.listByNamespaceAsync(resourceGroupName, namespaceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApplicationGroupInner>> createOrUpdateApplicationGroupWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName, ApplicationGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateApplicationGroup(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationGroupInner>> createOrUpdateApplicationGroupWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName, ApplicationGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateApplicationGroup(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApplicationGroupInner> createOrUpdateApplicationGroupAsync(String resourceGroupName, String namespaceName, String applicationGroupName, ApplicationGroupInner parameters) {
        return this.createOrUpdateApplicationGroupWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName, parameters).flatMap(res -> Mono.justOrEmpty((ApplicationGroupInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationGroupInner> createOrUpdateApplicationGroupWithResponse(String resourceGroupName, String namespaceName, String applicationGroupName, ApplicationGroupInner parameters, Context context) {
        return this.createOrUpdateApplicationGroupWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationGroupInner createOrUpdateApplicationGroup(String resourceGroupName, String namespaceName, String applicationGroupName, ApplicationGroupInner parameters) {
        return this.createOrUpdateApplicationGroupWithResponse(resourceGroupName, namespaceName, applicationGroupName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String applicationGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String applicationGroupName, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String applicationGroupName) {
        this.deleteWithResponse(resourceGroupName, namespaceName, applicationGroupName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApplicationGroupInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationGroupInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String applicationGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (applicationGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, applicationGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApplicationGroupInner> getAsync(String resourceGroupName, String namespaceName, String applicationGroupName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName).flatMap(res -> Mono.justOrEmpty((ApplicationGroupInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationGroupInner> getWithResponse(String resourceGroupName, String namespaceName, String applicationGroupName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, applicationGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationGroupInner get(String resourceGroupName, String namespaceName, String applicationGroupName) {
        return this.getWithResponse(resourceGroupName, namespaceName, applicationGroupName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationGroupInner>> listByNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationGroupInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGroupListResult)res.getValue()).value(), ((ApplicationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationGroupInner>> listByNamespaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationGroupInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGroupListResult)res.getValue()).value(), ((ApplicationGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventHubManagementCl")
    public static interface ApplicationGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGroupListResult>> listByNamespace(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGroupInner>> createOrUpdateApplicationGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="applicationGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") ApplicationGroupInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="applicationGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="applicationGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGroupListResult>> listByNamespaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

