/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.ArmDisasterRecoveryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubNamespaceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.NestedResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubDisasterRecoveryPairing;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.ProvisioningStateDR;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.RoleDisasterRecovery;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

class EventHubDisasterRecoveryPairingImpl
extends NestedResourceImpl<EventHubDisasterRecoveryPairing, ArmDisasterRecoveryInner, EventHubDisasterRecoveryPairingImpl>
implements EventHubDisasterRecoveryPairing,
EventHubDisasterRecoveryPairing.Definition,
EventHubDisasterRecoveryPairing.Update {
    private Ancestors.OneAncestor ancestor;
    private final ClientLogger logger = new ClientLogger(EventHubDisasterRecoveryPairingImpl.class);

    EventHubDisasterRecoveryPairingImpl(String name, ArmDisasterRecoveryInner inner, EventHubsManager manager) {
        super(name, inner, manager);
        this.ancestor = new Ancestors.OneAncestor(new Ancestors(), inner.id());
    }

    EventHubDisasterRecoveryPairingImpl(String name, EventHubsManager manager) {
        super(name, new ArmDisasterRecoveryInner(), manager);
    }

    @Override
    public String primaryNamespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String primaryNamespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public String secondaryNamespaceId() {
        return ((ArmDisasterRecoveryInner)this.innerModel()).partnerNamespace();
    }

    @Override
    public RoleDisasterRecovery namespaceRole() {
        return ((ArmDisasterRecoveryInner)this.innerModel()).role();
    }

    @Override
    public ProvisioningStateDR provisioningState() {
        return ((ArmDisasterRecoveryInner)this.innerModel()).provisioningState();
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewPrimaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        if (namespaceCreatable instanceof EventHubNamespaceImpl) {
            EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
            this.ancestor = new Ancestors.OneAncestor(new Ancestors(), namespace.resourceGroupName(), namespaceCreatable.name());
        } else {
            this.logger.logExceptionAsError(new IllegalArgumentException("The namespaceCreatable is invalid."));
        }
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(EventHubNamespace namespace) {
        this.ancestor = new Ancestors.OneAncestor(new Ancestors(), this.selfId(namespace.id()));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(String resourceGroupName, String primaryNamespaceName) {
        this.ancestor = new Ancestors.OneAncestor(new Ancestors(), resourceGroupName, primaryNamespaceName);
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespaceId(String namespaceId) {
        this.ancestor = new Ancestors.OneAncestor(new Ancestors(), this.selfId(namespaceId));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewSecondaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        if (namespaceCreatable instanceof EventHubNamespaceImpl) {
            EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
            ((ArmDisasterRecoveryInner)this.innerModel()).withPartnerNamespace(namespace.name());
        } else {
            this.logger.logExceptionAsError(new IllegalArgumentException("The namespaceCreatable is invalid."));
        }
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespace(EventHubNamespace namespace) {
        Objects.requireNonNull(namespace.id());
        ((ArmDisasterRecoveryInner)this.innerModel()).withPartnerNamespace(namespace.id());
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespaceId(String namespaceId) {
        Objects.requireNonNull(namespaceId);
        ((ArmDisasterRecoveryInner)this.innerModel()).withPartnerNamespace(namespaceId);
        return this;
    }

    @Override
    public Mono<EventHubDisasterRecoveryPairing> createResourceAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), (ArmDisasterRecoveryInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<Void> breakPairingAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().breakPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).then(this.refreshAsync()).then();
    }

    @Override
    public void breakPairing() {
        this.breakPairingAsync().block();
    }

    @Override
    public Mono<Void> failOverAsync() {
        ResourceId secondaryNs = ResourceId.fromString(((ArmDisasterRecoveryInner)this.innerModel()).partnerNamespace());
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().failOverAsync(secondaryNs.resourceGroupName(), secondaryNs.name(), this.name()).then(this.refreshAsync()).then();
    }

    @Override
    public void failOver() {
        this.failOverAsync().block();
    }

    @Override
    public PagedFlux<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRulesAsync() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedIterable<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRules() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairing(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    protected Mono<ArmDisasterRecoveryInner> getInnerAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/disasterRecoveryConfig/%s", parentId, this.name());
    }
}

