/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.UserAssignedIdentityProperties;
import java.io.IOException;

public final class KeyVaultProperties
implements JsonSerializable<KeyVaultProperties> {
    private String keyName;
    private String keyVaultUri;
    private String keyVersion;
    private UserAssignedIdentityProperties identity;

    public String keyName() {
        return this.keyName;
    }

    public KeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public KeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    public KeyVaultProperties withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    public UserAssignedIdentityProperties identity() {
        return this.identity;
    }

    public KeyVaultProperties withIdentity(UserAssignedIdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyVersion", this.keyVersion);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyName = reader.getString();
                    continue;
                }
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("keyVersion".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVersion = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedKeyVaultProperties.identity = UserAssignedIdentityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultProperties;
        });
    }
}

