/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.MetricId;
import java.io.IOException;

public final class ThrottlingPolicy
extends ApplicationGroupPolicy {
    private ApplicationGroupPolicyType type = ApplicationGroupPolicyType.THROTTLING_POLICY;
    private long rateLimitThreshold;
    private MetricId metricId;
    private static final ClientLogger LOGGER = new ClientLogger(ThrottlingPolicy.class);

    @Override
    public ApplicationGroupPolicyType type() {
        return this.type;
    }

    public long rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public ThrottlingPolicy withRateLimitThreshold(long rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    public MetricId metricId() {
        return this.metricId;
    }

    public ThrottlingPolicy withMetricId(MetricId metricId) {
        this.metricId = metricId;
        return this;
    }

    @Override
    public ThrottlingPolicy withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.metricId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property metricId in model ThrottlingPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeLongField("rateLimitThreshold", this.rateLimitThreshold);
        jsonWriter.writeStringField("metricId", this.metricId == null ? null : this.metricId.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ThrottlingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ThrottlingPolicy deserializedThrottlingPolicy = new ThrottlingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedThrottlingPolicy.withName(reader.getString());
                    continue;
                }
                if ("rateLimitThreshold".equals(fieldName)) {
                    deserializedThrottlingPolicy.rateLimitThreshold = reader.getLong();
                    continue;
                }
                if ("metricId".equals(fieldName)) {
                    deserializedThrottlingPolicy.metricId = MetricId.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedThrottlingPolicy.type = ApplicationGroupPolicyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThrottlingPolicy;
        });
    }
}

