/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyCurveName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyOperation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.KeyReleasePolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.RotationPolicy;
import java.io.IOException;
import java.util.List;

public final class KeyProperties
implements JsonSerializable<KeyProperties> {
    private KeyAttributes attributes;
    private JsonWebKeyType kty;
    private List<JsonWebKeyOperation> keyOps;
    private Integer keySize;
    private JsonWebKeyCurveName curveName;
    private String keyUri;
    private String keyUriWithVersion;
    private RotationPolicy rotationPolicy;
    private KeyReleasePolicy releasePolicy;

    public KeyAttributes attributes() {
        return this.attributes;
    }

    public KeyProperties withAttributes(KeyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWebKeyType kty() {
        return this.kty;
    }

    public KeyProperties withKty(JsonWebKeyType kty) {
        this.kty = kty;
        return this;
    }

    public List<JsonWebKeyOperation> keyOps() {
        return this.keyOps;
    }

    public KeyProperties withKeyOps(List<JsonWebKeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public KeyProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public JsonWebKeyCurveName curveName() {
        return this.curveName;
    }

    public KeyProperties withCurveName(JsonWebKeyCurveName curveName) {
        this.curveName = curveName;
        return this;
    }

    public String keyUri() {
        return this.keyUri;
    }

    public String keyUriWithVersion() {
        return this.keyUriWithVersion;
    }

    public RotationPolicy rotationPolicy() {
        return this.rotationPolicy;
    }

    public KeyProperties withRotationPolicy(RotationPolicy rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
        return this;
    }

    public KeyReleasePolicy releasePolicy() {
        return this.releasePolicy;
    }

    public KeyProperties withReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
        if (this.rotationPolicy() != null) {
            this.rotationPolicy().validate();
        }
        if (this.releasePolicy() != null) {
            this.releasePolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeStringField("kty", this.kty == null ? null : this.kty.toString());
        jsonWriter.writeArrayField("keyOps", this.keyOps, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("keySize", this.keySize);
        jsonWriter.writeStringField("curveName", this.curveName == null ? null : this.curveName.toString());
        jsonWriter.writeJsonField("rotationPolicy", this.rotationPolicy);
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyProperties deserializedKeyProperties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    deserializedKeyProperties.attributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedKeyProperties.kty = JsonWebKeyType.fromString(reader.getString());
                    continue;
                }
                if ("keyOps".equals(fieldName)) {
                    List<JsonWebKeyOperation> keyOps = reader.readArray(reader1 -> JsonWebKeyOperation.fromString(reader1.getString()));
                    deserializedKeyProperties.keyOps = keyOps;
                    continue;
                }
                if ("keySize".equals(fieldName)) {
                    deserializedKeyProperties.keySize = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("curveName".equals(fieldName)) {
                    deserializedKeyProperties.curveName = JsonWebKeyCurveName.fromString(reader.getString());
                    continue;
                }
                if ("keyUri".equals(fieldName)) {
                    deserializedKeyProperties.keyUri = reader.getString();
                    continue;
                }
                if ("keyUriWithVersion".equals(fieldName)) {
                    deserializedKeyProperties.keyUriWithVersion = reader.getString();
                    continue;
                }
                if ("rotationPolicy".equals(fieldName)) {
                    deserializedKeyProperties.rotationPolicy = RotationPolicy.fromJson(reader);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyProperties.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyProperties;
        });
    }
}

