/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ManagedHsmInner
extends ManagedHsmResource {
    private ManagedHsmProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ManagedHsmProperties properties() {
        return this.properties;
    }

    public ManagedHsmInner withProperties(ManagedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ManagedHsmInner withSku(ManagedHsmSku sku) {
        super.withSku(sku);
        return this;
    }

    @Override
    public ManagedHsmInner withIdentity(ManagedServiceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public ManagedHsmInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ManagedHsmInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("sku", this.sku());
        jsonWriter.writeJsonField("identity", this.identity());
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmInner deserializedManagedHsmInner = new ManagedHsmInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedHsmInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedHsmInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedHsmInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedHsmInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmInner.withTags((Map)tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagedHsmInner.withSku(ManagedHsmSku.fromJson(reader));
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedHsmInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedHsmInner.withIdentity(ManagedServiceIdentity.fromJson(reader));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmInner.properties = ManagedHsmProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmInner;
        });
    }
}

