/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JacksonAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.SecretImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Secret;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Secrets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.SecretProperties;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Objects;

class SecretsImpl
extends CreatableWrappersImpl<Secret, SecretImpl, SecretProperties>
implements Secrets {
    private final SecretAsyncClient inner;
    private final Vault vault;
    private final ClientLogger logger = new ClientLogger(SecretsImpl.class);

    SecretsImpl(SecretAsyncClient client, Vault vault) {
        this.inner = client;
        this.vault = vault;
    }

    @Override
    public SecretImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected SecretImpl wrapModel(String name) {
        return new SecretImpl(name, new SecretProperties(), this.vault);
    }

    @Override
    public Secret getById(String id) {
        return this.getByIdAsync(id).block();
    }

    @Override
    public Mono<Secret> getByIdAsync(String id) {
        String name = SecretsImpl.nameFromId(id);
        String version = SecretsImpl.versionFromId(id);
        return this.getByNameAndVersionAsync(name, version);
    }

    @Override
    protected SecretImpl wrapModel(SecretProperties secretProperties) {
        if (secretProperties == null) {
            return null;
        }
        return new SecretImpl(secretProperties.getName(), secretProperties, this.vault);
    }

    @Override
    protected SecretImpl wrapModel(KeyVaultSecret keyVaultSecret) {
        if (keyVaultSecret == null) {
            return null;
        }
        return new SecretImpl(keyVaultSecret.getName(), keyVaultSecret, this.vault);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        String name = SecretsImpl.nameFromId(id);
        return this.inner.beginDeleteSecret(name).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error(new RuntimeException("polling completed unsuccessfully with status:" + asyncPollResponse.getStatus()));
        });
    }

    @Override
    public PagedIterable<Secret> list() {
        return new PagedIterable<Secret>(this.listAsync());
    }

    @Override
    public PagedFlux<Secret> listAsync() {
        return PagedConverter.mapPage(this.inner.listPropertiesOfSecrets(), this::wrapModel);
    }

    @Override
    public Mono<Secret> getByNameAsync(String name) {
        return this.inner.getSecret(name).map(this::wrapModel);
    }

    @Override
    public Secret getByName(String name) {
        return this.getByNameAsync(name).block();
    }

    @Override
    public Secret getByNameAndVersion(String name, String version) {
        return this.getByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Secret> getByNameAndVersionAsync(String name, String version) {
        Objects.requireNonNull(name);
        return (version == null ? this.inner.getSecret(name) : this.inner.getSecret(name, version)).map(this::wrapModel);
    }

    @Override
    public Secret enableByNameAndVersion(String name, String version) {
        return this.enableByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Secret> enableByNameAndVersionAsync(String name, String version) {
        Objects.requireNonNull(name);
        return this.updateSecretEnableDisableAsync(name, version, true);
    }

    @Override
    public void disableByNameAndVersion(String name, String version) {
        this.disableByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Void> disableByNameAndVersionAsync(String name, String version) {
        Objects.requireNonNull(name);
        return this.updateSecretEnableDisableAsync(name, version, false).then();
    }

    private Mono<Secret> updateSecretEnableDisableAsync(String name, String version, boolean enabled) {
        try {
            String mockId = "https://mock.vault.azure.net/secrets/" + name;
            if (!CoreUtils.isNullOrEmpty(version)) {
                mockId = mockId + "/" + version;
            }
            HashMap<String, String> mockSecret = new HashMap<String, String>();
            mockSecret.put("id", mockId);
            SerializerAdapter serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
            String json = serializerAdapter.serialize(mockSecret, SerializerEncoding.JSON);
            SecretProperties secretProperties = (SecretProperties)serializerAdapter.deserialize(json, (Type)((Object)SecretProperties.class), SerializerEncoding.JSON);
            secretProperties.setEnabled(enabled);
            return this.vault.secretClient().updateSecretProperties(secretProperties).map(this::wrapModel);
        }
        catch (IOException ioe) {
            throw this.logger.logExceptionAsError(new RuntimeException(ioe));
        }
    }

    private static String nameFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String name = tokens.length >= 3 ? tokens[2] : null;
            return name;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }

    private static String versionFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String version = tokens.length >= 4 ? tokens[3] : null;
            return version;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }
}

