/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyProperties;
import java.io.IOException;
import java.util.Map;

public final class ManagedHsmKeyCreateParameters
implements JsonSerializable<ManagedHsmKeyCreateParameters> {
    private Map<String, String> tags;
    private ManagedHsmKeyProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmKeyCreateParameters.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedHsmKeyCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedHsmKeyProperties properties() {
        return this.properties;
    }

    public ManagedHsmKeyCreateParameters withProperties(ManagedHsmKeyProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property properties in model ManagedHsmKeyCreateParameters"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmKeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmKeyCreateParameters deserializedManagedHsmKeyCreateParameters = new ManagedHsmKeyCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmKeyCreateParameters.properties = ManagedHsmKeyProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmKeyCreateParameters.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmKeyCreateParameters;
        });
    }
}

