/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Attributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretAttributes
extends Attributes {
    private Long updated;
    private Long created;

    @Override
    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    @Override
    public SecretAttributes withEnabled(Boolean enabled) {
        super.withEnabled(enabled);
        return this;
    }

    @Override
    public SecretAttributes withNotBefore(OffsetDateTime notBefore) {
        super.withNotBefore(notBefore);
        return this;
    }

    @Override
    public SecretAttributes withExpires(OffsetDateTime expires) {
        super.withExpires(expires);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled());
        if (this.notBefore() != null) {
            jsonWriter.writeNumberField("nbf", this.notBefore().toEpochSecond());
        }
        if (this.expires() != null) {
            jsonWriter.writeNumberField("exp", this.expires().toEpochSecond());
        }
        return jsonWriter.writeEndObject();
    }

    public static SecretAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretAttributes deserializedSecretAttributes = new SecretAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedSecretAttributes.withEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    Long notBeforeHolder = reader.getNullable(JsonReader::getLong);
                    if (notBeforeHolder == null) continue;
                    deserializedSecretAttributes.withNotBefore(OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBeforeHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    Long expiresHolder = reader.getNullable(JsonReader::getLong);
                    if (expiresHolder == null) continue;
                    deserializedSecretAttributes.withExpires(OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSecretAttributes.created = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedSecretAttributes.updated = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretAttributes;
        });
    }
}

