/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.VaultProperties;
import java.io.IOException;
import java.util.Map;

public final class VaultCreateOrUpdateParameters
implements JsonSerializable<VaultCreateOrUpdateParameters> {
    private String location;
    private Map<String, String> tags;
    private VaultProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(VaultCreateOrUpdateParameters.class);

    public String location() {
        return this.location;
    }

    public VaultCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VaultCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public VaultProperties properties() {
        return this.properties;
    }

    public VaultCreateOrUpdateParameters withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model VaultCreateOrUpdateParameters"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property properties in model VaultCreateOrUpdateParameters"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static VaultCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VaultCreateOrUpdateParameters deserializedVaultCreateOrUpdateParameters = new VaultCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedVaultCreateOrUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVaultCreateOrUpdateParameters.properties = VaultProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVaultCreateOrUpdateParameters.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultCreateOrUpdateParameters;
        });
    }
}

