/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.MonitorManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.AutoscaleSettingResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.AutoscaleProfileImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AutoscaleProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AutoscaleSetting;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.EmailNotification;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.WebhookNotification;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AutoscaleSettingImpl
extends GroupableResourceImpl<AutoscaleSetting, AutoscaleSettingResourceInner, AutoscaleSettingImpl, MonitorManager>
implements AutoscaleSetting,
AutoscaleSetting.Definition,
AutoscaleSetting.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    AutoscaleSettingImpl(String name, AutoscaleSettingResourceInner innerModel, MonitorManager monitorManager) {
        super(name, innerModel, monitorManager);
        if (this.isInCreateMode()) {
            ((AutoscaleSettingResourceInner)this.innerModel()).withEnabled(true);
        }
        if (((AutoscaleSettingResourceInner)this.innerModel()).notifications() == null) {
            ((AutoscaleSettingResourceInner)this.innerModel()).withNotifications(new ArrayList<AutoscaleNotification>());
            ((AutoscaleSettingResourceInner)this.innerModel()).notifications().add(new AutoscaleNotification());
        }
        if (((AutoscaleSettingResourceInner)this.innerModel()).profiles() == null) {
            ((AutoscaleSettingResourceInner)this.innerModel()).withProfiles(new ArrayList<AutoscaleProfileInner>());
        }
    }

    @Override
    public String targetResourceId() {
        return ((AutoscaleSettingResourceInner)this.innerModel()).targetResourceUri();
    }

    @Override
    public Map<String, AutoscaleProfile> profiles() {
        HashMap<String, AutoscaleProfile> result = new HashMap<String, AutoscaleProfile>();
        for (AutoscaleProfileInner profileInner : ((AutoscaleSettingResourceInner)this.innerModel()).profiles()) {
            AutoscaleProfileImpl profileImpl = new AutoscaleProfileImpl(profileInner.name(), profileInner, this);
            result.put(profileImpl.name(), profileImpl);
        }
        return result;
    }

    @Override
    public boolean autoscaleEnabled() {
        return ((AutoscaleSettingResourceInner)this.innerModel()).enabled();
    }

    @Override
    public boolean adminEmailNotificationEnabled() {
        if (((AutoscaleSettingResourceInner)this.innerModel()).notifications() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0) != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email() != null) {
            return ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email().sendToSubscriptionAdministrator();
        }
        return false;
    }

    @Override
    public boolean coAdminEmailNotificationEnabled() {
        if (((AutoscaleSettingResourceInner)this.innerModel()).notifications() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0) != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email() != null) {
            return ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email().sendToSubscriptionCoAdministrators();
        }
        return false;
    }

    @Override
    public List<String> customEmailsNotification() {
        if (((AutoscaleSettingResourceInner)this.innerModel()).notifications() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0) != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email().customEmails() != null) {
            return ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email().customEmails();
        }
        return new ArrayList<String>();
    }

    @Override
    public String webhookNotification() {
        if (((AutoscaleSettingResourceInner)this.innerModel()).notifications() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0) != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).email() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).webhooks() != null && ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).webhooks().size() > 0) {
            return ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0).webhooks().get(0).serviceUri();
        }
        return null;
    }

    @Override
    public AutoscaleProfileImpl defineAutoscaleProfile(String name) {
        return new AutoscaleProfileImpl(name, new AutoscaleProfileInner(), this);
    }

    @Override
    public AutoscaleProfileImpl updateAutoscaleProfile(String name) {
        int idx = this.getProfileIndexByName(name);
        if (idx == -1) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Cannot find autoscale profile with the name '" + name + "'"));
        }
        AutoscaleProfileInner innerProfile = ((AutoscaleSettingResourceInner)this.innerModel()).profiles().get(idx);
        return new AutoscaleProfileImpl(innerProfile.name(), innerProfile, this);
    }

    @Override
    public AutoscaleSettingImpl withoutAutoscaleProfile(String name) {
        int idx = this.getProfileIndexByName(name);
        if (idx != -1) {
            ((AutoscaleSettingResourceInner)this.innerModel()).profiles().remove(idx);
        }
        return this;
    }

    @Override
    public AutoscaleSettingImpl withTargetResource(String targetResourceId) {
        ((AutoscaleSettingResourceInner)this.innerModel()).withTargetResourceUri(targetResourceId);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionAdministrator(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withCoAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionCoAdministrators(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withCustomEmailsNotification(String ... customEmailAddresses) {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withCustomEmails(new ArrayList<String>());
        for (String strEmail : customEmailAddresses) {
            notificationInner.email().customEmails().add(strEmail);
        }
        return this;
    }

    @Override
    public AutoscaleSettingImpl withWebhookNotification(String serviceUri) {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        if (notificationInner.webhooks() == null) {
            notificationInner.withWebhooks(new ArrayList<WebhookNotification>());
        }
        if (notificationInner.webhooks().isEmpty()) {
            notificationInner.webhooks().add(new WebhookNotification());
        }
        notificationInner.webhooks().get(0).withServiceUri(serviceUri);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionAdministrator(false);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutCoAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionCoAdministrators(false);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutCustomEmailsNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withCustomEmails(null);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutWebhookNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.withWebhooks(null);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAutoscaleEnabled() {
        ((AutoscaleSettingResourceInner)this.innerModel()).withEnabled(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAutoscaleDisabled() {
        ((AutoscaleSettingResourceInner)this.innerModel()).withEnabled(false);
        return this;
    }

    @Override
    public Mono<AutoscaleSetting> createResourceAsync() {
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getAutoscaleSettings().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AutoscaleSettingResourceInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<AutoscaleSettingResourceInner> getInnerAsync() {
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getAutoscaleSettings().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public AutoscaleSettingImpl addNewAutoscaleProfile(AutoscaleProfileImpl profile) {
        ((AutoscaleSettingResourceInner)this.innerModel()).profiles().add((AutoscaleProfileInner)profile.innerModel());
        return this;
    }

    private int getProfileIndexByName(String name) {
        int idxResult = -1;
        for (int idx = 0; idx < ((AutoscaleSettingResourceInner)this.innerModel()).profiles().size(); ++idx) {
            if (!((AutoscaleSettingResourceInner)this.innerModel()).profiles().get(idx).name().equalsIgnoreCase(name)) continue;
            idxResult = idx;
            break;
        }
        return idxResult;
    }

    private AutoscaleNotification getNotificationInner() {
        AutoscaleNotification notificationInner = ((AutoscaleSettingResourceInner)this.innerModel()).notifications().get(0);
        if (notificationInner.email() == null) {
            notificationInner.withEmail(new EmailNotification());
        }
        return notificationInner;
    }
}

