/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.PredictiveMetricsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.PredictiveResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;

public final class PredictiveMetricsClientImpl
implements PredictiveMetricsClient {
    private final PredictiveMetricsService service;
    private final MonitorClientImpl client;

    PredictiveMetricsClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(PredictiveMetricsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PredictiveResponseInner>> getWithResponseAsync(String resourceGroupName, String autoscaleSettingName, String timespan, Duration interval, String metricNamespace, String metricName, String aggregation) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (autoscaleSettingName == null) {
            return Mono.error(new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null."));
        }
        if (timespan == null) {
            return Mono.error(new IllegalArgumentException("Parameter timespan is required and cannot be null."));
        }
        if (interval == null) {
            return Mono.error(new IllegalArgumentException("Parameter interval is required and cannot be null."));
        }
        if (metricNamespace == null) {
            return Mono.error(new IllegalArgumentException("Parameter metricNamespace is required and cannot be null."));
        }
        if (metricName == null) {
            return Mono.error(new IllegalArgumentException("Parameter metricName is required and cannot be null."));
        }
        if (aggregation == null) {
            return Mono.error(new IllegalArgumentException("Parameter aggregation is required and cannot be null."));
        }
        String apiVersion = "2022-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation, "2022-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PredictiveResponseInner>> getWithResponseAsync(String resourceGroupName, String autoscaleSettingName, String timespan, Duration interval, String metricNamespace, String metricName, String aggregation, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (autoscaleSettingName == null) {
            return Mono.error(new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null."));
        }
        if (timespan == null) {
            return Mono.error(new IllegalArgumentException("Parameter timespan is required and cannot be null."));
        }
        if (interval == null) {
            return Mono.error(new IllegalArgumentException("Parameter interval is required and cannot be null."));
        }
        if (metricNamespace == null) {
            return Mono.error(new IllegalArgumentException("Parameter metricNamespace is required and cannot be null."));
        }
        if (metricName == null) {
            return Mono.error(new IllegalArgumentException("Parameter metricName is required and cannot be null."));
        }
        if (aggregation == null) {
            return Mono.error(new IllegalArgumentException("Parameter aggregation is required and cannot be null."));
        }
        String apiVersion = "2022-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation, "2022-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PredictiveResponseInner> getAsync(String resourceGroupName, String autoscaleSettingName, String timespan, Duration interval, String metricNamespace, String metricName, String aggregation) {
        return this.getWithResponseAsync(resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation).flatMap(res -> Mono.justOrEmpty((PredictiveResponseInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PredictiveResponseInner> getWithResponse(String resourceGroupName, String autoscaleSettingName, String timespan, Duration interval, String metricNamespace, String metricName, String aggregation, Context context) {
        return this.getWithResponseAsync(resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PredictiveResponseInner get(String resourceGroupName, String autoscaleSettingName, String timespan, Duration interval, String metricNamespace, String metricName, String aggregation) {
        return this.getWithResponse(resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientPredict")
    public static interface PredictiveMetricsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/autoscalesettings/{autoscaleSettingName}/predictiveMetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PredictiveResponseInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="autoscaleSettingName") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="metricNamespace") String var7, @QueryParam(value="metricName") String var8, @QueryParam(value="aggregation") String var9, @QueryParam(value="api-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);
    }
}

