/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AccessMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AccessModeSettingsExclusion;
import java.io.IOException;
import java.util.List;

public final class AccessModeSettings
implements JsonSerializable<AccessModeSettings> {
    private AccessMode queryAccessMode;
    private AccessMode ingestionAccessMode;
    private List<AccessModeSettingsExclusion> exclusions;
    private static final ClientLogger LOGGER = new ClientLogger(AccessModeSettings.class);

    public AccessMode queryAccessMode() {
        return this.queryAccessMode;
    }

    public AccessModeSettings withQueryAccessMode(AccessMode queryAccessMode) {
        this.queryAccessMode = queryAccessMode;
        return this;
    }

    public AccessMode ingestionAccessMode() {
        return this.ingestionAccessMode;
    }

    public AccessModeSettings withIngestionAccessMode(AccessMode ingestionAccessMode) {
        this.ingestionAccessMode = ingestionAccessMode;
        return this;
    }

    public List<AccessModeSettingsExclusion> exclusions() {
        return this.exclusions;
    }

    public AccessModeSettings withExclusions(List<AccessModeSettingsExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public void validate() {
        if (this.queryAccessMode() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property queryAccessMode in model AccessModeSettings"));
        }
        if (this.ingestionAccessMode() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ingestionAccessMode in model AccessModeSettings"));
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryAccessMode", this.queryAccessMode == null ? null : this.queryAccessMode.toString());
        jsonWriter.writeStringField("ingestionAccessMode", this.ingestionAccessMode == null ? null : this.ingestionAccessMode.toString());
        jsonWriter.writeArrayField("exclusions", this.exclusions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AccessModeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessModeSettings deserializedAccessModeSettings = new AccessModeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryAccessMode".equals(fieldName)) {
                    deserializedAccessModeSettings.queryAccessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                if ("ingestionAccessMode".equals(fieldName)) {
                    deserializedAccessModeSettings.ingestionAccessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                if ("exclusions".equals(fieldName)) {
                    List<AccessModeSettingsExclusion> exclusions = reader.readArray(reader1 -> AccessModeSettingsExclusion.fromJson(reader1));
                    deserializedAccessModeSettings.exclusions = exclusions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessModeSettings;
        });
    }
}

