/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.KnownExtensionDataSourceStreams;
import java.io.IOException;
import java.util.List;

public final class ExtensionDataSource
implements JsonSerializable<ExtensionDataSource> {
    private List<KnownExtensionDataSourceStreams> streams;
    private String extensionName;
    private Object extensionSettings;
    private List<String> inputDataSources;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ExtensionDataSource.class);

    public List<KnownExtensionDataSourceStreams> streams() {
        return this.streams;
    }

    public ExtensionDataSource withStreams(List<KnownExtensionDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    public String extensionName() {
        return this.extensionName;
    }

    public ExtensionDataSource withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    public Object extensionSettings() {
        return this.extensionSettings;
    }

    public ExtensionDataSource withExtensionSettings(Object extensionSettings) {
        this.extensionSettings = extensionSettings;
        return this;
    }

    public List<String> inputDataSources() {
        return this.inputDataSources;
    }

    public ExtensionDataSource withInputDataSources(List<String> inputDataSources) {
        this.inputDataSources = inputDataSources;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ExtensionDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.extensionName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property extensionName in model ExtensionDataSource"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeUntypedField("extensionSettings", this.extensionSettings);
        jsonWriter.writeArrayField("inputDataSources", this.inputDataSources, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ExtensionDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExtensionDataSource deserializedExtensionDataSource = new ExtensionDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extensionName".equals(fieldName)) {
                    deserializedExtensionDataSource.extensionName = reader.getString();
                    continue;
                }
                if ("streams".equals(fieldName)) {
                    List<KnownExtensionDataSourceStreams> streams = reader.readArray(reader1 -> KnownExtensionDataSourceStreams.fromString(reader1.getString()));
                    deserializedExtensionDataSource.streams = streams;
                    continue;
                }
                if ("extensionSettings".equals(fieldName)) {
                    deserializedExtensionDataSource.extensionSettings = reader.readUntyped();
                    continue;
                }
                if ("inputDataSources".equals(fieldName)) {
                    List<String> inputDataSources = reader.readArray(reader1 -> reader1.getString());
                    deserializedExtensionDataSource.inputDataSources = inputDataSources;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExtensionDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtensionDataSource;
        });
    }
}

