/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.KnownLogFilesDataSourceFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.LogFilesDataSourceSettings;
import java.io.IOException;
import java.util.List;

public final class LogFilesDataSource
implements JsonSerializable<LogFilesDataSource> {
    private List<String> streams;
    private List<String> filePatterns;
    private KnownLogFilesDataSourceFormat format;
    private LogFilesDataSourceSettings settings;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(LogFilesDataSource.class);

    public List<String> streams() {
        return this.streams;
    }

    public LogFilesDataSource withStreams(List<String> streams) {
        this.streams = streams;
        return this;
    }

    public List<String> filePatterns() {
        return this.filePatterns;
    }

    public LogFilesDataSource withFilePatterns(List<String> filePatterns) {
        this.filePatterns = filePatterns;
        return this;
    }

    public KnownLogFilesDataSourceFormat format() {
        return this.format;
    }

    public LogFilesDataSource withFormat(KnownLogFilesDataSourceFormat format) {
        this.format = format;
        return this;
    }

    public LogFilesDataSourceSettings settings() {
        return this.settings;
    }

    public LogFilesDataSource withSettings(LogFilesDataSourceSettings settings) {
        this.settings = settings;
        return this;
    }

    public String name() {
        return this.name;
    }

    public LogFilesDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.streams() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property streams in model LogFilesDataSource"));
        }
        if (this.filePatterns() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property filePatterns in model LogFilesDataSource"));
        }
        if (this.format() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property format in model LogFilesDataSource"));
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("filePatterns", this.filePatterns, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        jsonWriter.writeJsonField("settings", this.settings);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static LogFilesDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFilesDataSource deserializedLogFilesDataSource = new LogFilesDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streams".equals(fieldName)) {
                    List<String> streams = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogFilesDataSource.streams = streams;
                    continue;
                }
                if ("filePatterns".equals(fieldName)) {
                    List<String> filePatterns = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogFilesDataSource.filePatterns = filePatterns;
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedLogFilesDataSource.format = KnownLogFilesDataSourceFormat.fromString(reader.getString());
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedLogFilesDataSource.settings = LogFilesDataSourceSettings.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLogFilesDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogFilesDataSource;
        });
    }
}

