/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AggregationTypeEnum;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.CriterionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricDimension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MultiMetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.Operator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MetricCriteria
extends MultiMetricCriteria {
    private CriterionType criterionType = CriterionType.STATIC_THRESHOLD_CRITERION;
    private Operator operator;
    private double threshold;
    private static final ClientLogger LOGGER = new ClientLogger(MetricCriteria.class);

    @Override
    public CriterionType criterionType() {
        return this.criterionType;
    }

    public Operator operator() {
        return this.operator;
    }

    public MetricCriteria withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public MetricCriteria withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public MetricCriteria withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MetricCriteria withMetricName(String metricName) {
        super.withMetricName(metricName);
        return this;
    }

    @Override
    public MetricCriteria withMetricNamespace(String metricNamespace) {
        super.withMetricNamespace(metricNamespace);
        return this;
    }

    @Override
    public MetricCriteria withTimeAggregation(AggregationTypeEnum timeAggregation) {
        super.withTimeAggregation(timeAggregation);
        return this;
    }

    @Override
    public MetricCriteria withDimensions(List<MetricDimension> dimensions) {
        super.withDimensions(dimensions);
        return this;
    }

    @Override
    public MetricCriteria withSkipMetricValidation(Boolean skipMetricValidation) {
        super.withSkipMetricValidation(skipMetricValidation);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model MetricCriteria"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("metricName", this.metricName());
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation() == null ? null : this.timeAggregation().toString());
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace());
        jsonWriter.writeArrayField("dimensions", this.dimensions(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("skipMetricValidation", this.skipMetricValidation());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeDoubleField("threshold", this.threshold);
        jsonWriter.writeStringField("criterionType", this.criterionType == null ? null : this.criterionType.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MetricCriteria fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricCriteria deserializedMetricCriteria = new MetricCriteria();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricCriteria.withName(reader.getString());
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedMetricCriteria.withMetricName(reader.getString());
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedMetricCriteria.withTimeAggregation(AggregationTypeEnum.fromString(reader.getString()));
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedMetricCriteria.withMetricNamespace(reader.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List<MetricDimension> dimensions = reader.readArray(reader1 -> MetricDimension.fromJson(reader1));
                    deserializedMetricCriteria.withDimensions((List)dimensions);
                    continue;
                }
                if ("skipMetricValidation".equals(fieldName)) {
                    deserializedMetricCriteria.withSkipMetricValidation(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMetricCriteria.operator = Operator.fromString(reader.getString());
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedMetricCriteria.threshold = reader.getDouble();
                    continue;
                }
                if ("criterionType".equals(fieldName)) {
                    deserializedMetricCriteria.criterionType = CriterionType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMetricCriteria.withAdditionalProperties(additionalProperties);
            return deserializedMetricCriteria;
        });
    }
}

