/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureFirewallNetworkRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AzureFirewallNetworkRuleCollectionPropertiesFormat
implements JsonSerializable<AzureFirewallNetworkRuleCollectionPropertiesFormat> {
    private Integer priority;
    private AzureFirewallRCAction action;
    private List<AzureFirewallNetworkRule> rules;
    private ProvisioningState provisioningState;

    public Integer priority() {
        return this.priority;
    }

    public AzureFirewallNetworkRuleCollectionPropertiesFormat withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.action;
    }

    public AzureFirewallNetworkRuleCollectionPropertiesFormat withAction(AzureFirewallRCAction action) {
        this.action = action;
        return this;
    }

    public List<AzureFirewallNetworkRule> rules() {
        return this.rules;
    }

    public AzureFirewallNetworkRuleCollectionPropertiesFormat withRules(List<AzureFirewallNetworkRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeJsonField("action", this.action);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallNetworkRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallNetworkRuleCollectionPropertiesFormat deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat = new AzureFirewallNetworkRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat.priority = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat.action = AzureFirewallRCAction.fromJson(reader);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List<AzureFirewallNetworkRule> rules = reader.readArray(reader1 -> AzureFirewallNetworkRule.fromJson(reader1));
                    deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat.rules = rules;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallNetworkRuleCollectionPropertiesFormat;
        });
    }
}

