/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetworkSecurityGroupInner
extends Resource {
    private NetworkSecurityGroupPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private NetworkSecurityGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NetworkSecurityGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public NetworkSecurityGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public NetworkSecurityGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean flushConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().flushConnection();
    }

    public NetworkSecurityGroupInner withFlushConnection(Boolean flushConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityGroupPropertiesFormat();
        }
        this.innerProperties().withFlushConnection(flushConnection);
        return this;
    }

    public List<SecurityRuleInner> securityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().securityRules();
    }

    public NetworkSecurityGroupInner withSecurityRules(List<SecurityRuleInner> securityRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityGroupPropertiesFormat();
        }
        this.innerProperties().withSecurityRules(securityRules);
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecurityRules();
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public List<FlowLogInner> flowLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().flowLogs();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityGroupInner deserializedNetworkSecurityGroupInner = new NetworkSecurityGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkSecurityGroupInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.innerProperties = NetworkSecurityGroupPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityGroupInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupInner;
        });
    }
}

