/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class OutboundRulePropertiesFormat
implements JsonSerializable<OutboundRulePropertiesFormat> {
    private Integer allocatedOutboundPorts;
    private List<SubResource> frontendIpConfigurations;
    private SubResource backendAddressPool;
    private ProvisioningState provisioningState;
    private LoadBalancerOutboundRuleProtocol protocol;
    private Boolean enableTcpReset;
    private Integer idleTimeoutInMinutes;
    private static final ClientLogger LOGGER = new ClientLogger(OutboundRulePropertiesFormat.class);

    public Integer allocatedOutboundPorts() {
        return this.allocatedOutboundPorts;
    }

    public OutboundRulePropertiesFormat withAllocatedOutboundPorts(Integer allocatedOutboundPorts) {
        this.allocatedOutboundPorts = allocatedOutboundPorts;
        return this;
    }

    public List<SubResource> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    public OutboundRulePropertiesFormat withFrontendIpConfigurations(List<SubResource> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    public OutboundRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public LoadBalancerOutboundRuleProtocol protocol() {
        return this.protocol;
    }

    public OutboundRulePropertiesFormat withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    public OutboundRulePropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public OutboundRulePropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public void validate() {
        if (this.frontendIpConfigurations() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property frontendIpConfigurations in model OutboundRulePropertiesFormat"));
        }
        if (this.backendAddressPool() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property backendAddressPool in model OutboundRulePropertiesFormat"));
        }
        if (this.protocol() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property protocol in model OutboundRulePropertiesFormat"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("frontendIPConfigurations", this.frontendIpConfigurations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("allocatedOutboundPorts", this.allocatedOutboundPorts);
        jsonWriter.writeBooleanField("enableTcpReset", this.enableTcpReset);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", this.idleTimeoutInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static OutboundRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OutboundRulePropertiesFormat deserializedOutboundRulePropertiesFormat = new OutboundRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frontendIPConfigurations".equals(fieldName)) {
                    List<SubResource> frontendIpConfigurations = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedOutboundRulePropertiesFormat.frontendIpConfigurations = frontendIpConfigurations;
                    continue;
                }
                if ("backendAddressPool".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.backendAddressPool = SubResource.fromJson(reader);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.protocol = LoadBalancerOutboundRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("allocatedOutboundPorts".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.allocatedOutboundPorts = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("enableTcpReset".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.enableTcpReset = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.idleTimeoutInMinutes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundRulePropertiesFormat;
        });
    }
}

