/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;
import java.util.List;

public final class P2SConnectionConfigurationProperties
implements JsonSerializable<P2SConnectionConfigurationProperties> {
    private AddressSpace vpnClientAddressPool;
    private RoutingConfiguration routingConfiguration;
    private Boolean enableInternetSecurity;
    private List<SubResource> configurationPolicyGroupAssociations;
    private List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations;
    private ProvisioningState provisioningState;

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public P2SConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public P2SConnectionConfigurationProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public P2SConnectionConfigurationProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public List<SubResource> configurationPolicyGroupAssociations() {
        return this.configurationPolicyGroupAssociations;
    }

    public List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations() {
        return this.previousConfigurationPolicyGroupAssociations;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.vpnClientAddressPool() != null) {
            this.vpnClientAddressPool().validate();
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
        if (this.previousConfigurationPolicyGroupAssociations() != null) {
            this.previousConfigurationPolicyGroupAssociations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnClientAddressPool", this.vpnClientAddressPool);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        return jsonWriter.writeEndObject();
    }

    public static P2SConnectionConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            P2SConnectionConfigurationProperties deserializedP2SConnectionConfigurationProperties = new P2SConnectionConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vpnClientAddressPool".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.vpnClientAddressPool = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("routingConfiguration".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.routingConfiguration = RoutingConfiguration.fromJson(reader);
                    continue;
                }
                if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.enableInternetSecurity = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("configurationPolicyGroupAssociations".equals(fieldName)) {
                    List<SubResource> configurationPolicyGroupAssociations = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedP2SConnectionConfigurationProperties.configurationPolicyGroupAssociations = configurationPolicyGroupAssociations;
                    continue;
                }
                if ("previousConfigurationPolicyGroupAssociations".equals(fieldName)) {
                    List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupInner.fromJson(reader1));
                    deserializedP2SConnectionConfigurationProperties.previousConfigurationPolicyGroupAssociations = previousConfigurationPolicyGroupAssociations;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedP2SConnectionConfigurationProperties;
        });
    }
}

