/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteNextHopType;
import java.io.IOException;

public final class RoutePropertiesFormat
implements JsonSerializable<RoutePropertiesFormat> {
    private String addressPrefix;
    private RouteNextHopType nextHopType;
    private String nextHopIpAddress;
    private ProvisioningState provisioningState;
    private Boolean hasBgpOverride;
    private static final ClientLogger LOGGER = new ClientLogger(RoutePropertiesFormat.class);

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public RoutePropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    public RoutePropertiesFormat withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    public String nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    public RoutePropertiesFormat withNextHopIpAddress(String nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean hasBgpOverride() {
        return this.hasBgpOverride;
    }

    public void validate() {
        if (this.nextHopType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property nextHopType in model RoutePropertiesFormat"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeStringField("nextHopIpAddress", this.nextHopIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static RoutePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutePropertiesFormat deserializedRoutePropertiesFormat = new RoutePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextHopType".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.nextHopType = RouteNextHopType.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.addressPrefix = reader.getString();
                    continue;
                }
                if ("nextHopIpAddress".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.nextHopIpAddress = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("hasBgpOverride".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.hasBgpOverride = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutePropertiesFormat;
        });
    }
}

