/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualWanProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.OfficeTrafficCategory;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualWanInner
extends Resource {
    private VirtualWanProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VirtualWanProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public VirtualWanInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public VirtualWanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public VirtualWanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean disableVpnEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().disableVpnEncryption();
    }

    public VirtualWanInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withDisableVpnEncryption(disableVpnEncryption);
        return this;
    }

    public List<SubResource> virtualHubs() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHubs();
    }

    public List<SubResource> vpnSites() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSites();
    }

    public Boolean allowBranchToBranchTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBranchToBranchTraffic();
    }

    public VirtualWanInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowBranchToBranchTraffic(allowBranchToBranchTraffic);
        return this;
    }

    public Boolean allowVnetToVnetTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowVnetToVnetTraffic();
    }

    public VirtualWanInner withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowVnetToVnetTraffic(allowVnetToVnetTraffic);
        return this;
    }

    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.innerProperties() == null ? null : this.innerProperties().office365LocalBreakoutCategory();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public VirtualWanInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VirtualWanInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualWanInner deserializedVirtualWanInner = new VirtualWanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualWanInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualWanInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualWanInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualWanInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualWanInner.innerProperties = VirtualWanProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualWanInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualWanInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualWanInner;
        });
    }
}

