/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.ConnectionMonitorsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ConnectionMonitorInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ConnectionMonitorQueryResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ConnectionMonitorResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ConnectionMonitorQueryResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorQueryResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkWatcher;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ConnectionMonitorImpl
extends CreatableUpdatableImpl<ConnectionMonitor, ConnectionMonitorResultInner, ConnectionMonitorImpl>
implements ConnectionMonitor,
ConnectionMonitor.Definition {
    private final ConnectionMonitorsClient client;
    private final ConnectionMonitorInner createParameters;
    private final NetworkWatcher parent;

    ConnectionMonitorImpl(String name, NetworkWatcherImpl parent, ConnectionMonitorResultInner innerObject, ConnectionMonitorsClient client) {
        super(name, innerObject);
        this.client = client;
        this.parent = parent;
        this.createParameters = new ConnectionMonitorInner().withLocation(parent.regionName());
    }

    @Override
    protected Mono<ConnectionMonitorResultInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    @Override
    public String location() {
        return ((ConnectionMonitorResultInner)this.innerModel()).location();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> tags = ((ConnectionMonitorResultInner)this.innerModel()).tags();
        if (tags == null) {
            tags = new TreeMap<String, String>();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public ConnectionMonitorSource source() {
        return ((ConnectionMonitorResultInner)this.innerModel()).source();
    }

    @Override
    public ConnectionMonitorDestination destination() {
        return ((ConnectionMonitorResultInner)this.innerModel()).destination();
    }

    @Override
    public boolean autoStart() {
        return ResourceManagerUtils.toPrimitiveBoolean(((ConnectionMonitorResultInner)this.innerModel()).autoStart());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ConnectionMonitorResultInner)this.innerModel()).provisioningState();
    }

    @Override
    public OffsetDateTime startTime() {
        return ((ConnectionMonitorResultInner)this.innerModel()).startTime();
    }

    @Override
    public String monitoringStatus() {
        return ((ConnectionMonitorResultInner)this.innerModel()).monitoringStatus();
    }

    @Override
    public int monitoringIntervalInSeconds() {
        return ResourceManagerUtils.toPrimitiveInt(((ConnectionMonitorResultInner)this.innerModel()).monitoringIntervalInSeconds());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return this.client.stopAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).flatMap(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return this.client.startAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).flatMap(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public ConnectionMonitorQueryResult query() {
        return this.queryAsync().block();
    }

    @Override
    public Mono<ConnectionMonitorQueryResult> queryAsync() {
        return this.client.queryAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).map(inner -> new ConnectionMonitorQueryResultImpl((ConnectionMonitorQueryResultInner)inner));
    }

    @Override
    public boolean isInCreateMode() {
        return ((ConnectionMonitorResultInner)this.innerModel()).id() == null;
    }

    @Override
    public Mono<ConnectionMonitor> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), this.createParameters).map(this.innerToFluentMap(this));
    }

    @Override
    public String id() {
        return ((ConnectionMonitorResultInner)this.innerModel()).id();
    }

    @Override
    public ConnectionMonitorImpl withSourceId(String resourceId) {
        this.ensureConnectionMonitorSource().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withSource(HasNetworkInterfaces vm) {
        this.ensureConnectionMonitorSource().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectionMonitorImpl withDestinationId(String resourceId) {
        this.ensureConnectionMonitorDestination().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withDestination(HasNetworkInterfaces vm) {
        this.ensureConnectionMonitorDestination().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectionMonitor.DefinitionStages.WithDestinationPort withDestinationAddress(String address) {
        this.ensureConnectionMonitorDestination().withAddress(address);
        return this;
    }

    private ConnectionMonitorSource ensureConnectionMonitorSource() {
        if (this.createParameters.source() == null) {
            this.createParameters.withSource(new ConnectionMonitorSource());
        }
        return this.createParameters.source();
    }

    private ConnectionMonitorDestination ensureConnectionMonitorDestination() {
        if (this.createParameters.destination() == null) {
            this.createParameters.withDestination(new ConnectionMonitorDestination());
        }
        return this.createParameters.destination();
    }

    @Override
    public ConnectionMonitorImpl withDestinationPort(int port) {
        this.ensureConnectionMonitorDestination().withPort(port);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withSourcePort(int port) {
        this.ensureConnectionMonitorSource().withPort(port);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withoutAutoStart() {
        this.createParameters.withAutoStart(false);
        return this;
    }

    @Override
    public final ConnectionMonitorImpl withTags(Map<String, String> tags) {
        this.createParameters.withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public ConnectionMonitorImpl withTag(String key, String value) {
        if (this.createParameters.tags() == null) {
            this.createParameters.withTags(new HashMap<String, String>());
        }
        this.createParameters.tags().put(key, value);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withoutTag(String key) {
        if (this.createParameters.tags() != null) {
            this.createParameters.tags().remove(key);
        }
        return this;
    }

    @Override
    public ConnectionMonitorImpl withMonitoringInterval(int seconds) {
        this.createParameters.withMonitoringIntervalInSeconds(seconds);
        return this;
    }
}

