/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerOutboundRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LoadBalancerOutboundRuleImpl
extends ChildResourceImpl<OutboundRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerOutboundRule,
LoadBalancerOutboundRule.Definition<LoadBalancerImpl>,
LoadBalancerOutboundRule.Update<LoadBalancerImpl> {
    LoadBalancerOutboundRuleImpl(OutboundRuleInner inner, LoadBalancerImpl parent) {
        super(inner, parent);
    }

    @Override
    public LoadBalancerOutboundRuleProtocol protocol() {
        return ((OutboundRuleInner)this.innerModel()).protocol();
    }

    @Override
    public Map<String, LoadBalancerFrontend> frontends() {
        TreeMap<String, LoadBalancerFrontend> nameToFrontEndMap = new TreeMap<String, LoadBalancerFrontend>();
        if (((OutboundRuleInner)this.innerModel()).frontendIpConfigurations() != null && !((OutboundRuleInner)this.innerModel()).frontendIpConfigurations().isEmpty()) {
            for (SubResource frontendIpConfiguration : ((OutboundRuleInner)this.innerModel()).frontendIpConfigurations()) {
                LoadBalancerFrontend frontend = ((LoadBalancerImpl)this.parent()).frontends().get(ResourceUtils.nameFromResourceId(frontendIpConfiguration.id()));
                nameToFrontEndMap.put(frontend.name(), frontend);
            }
        }
        return Collections.unmodifiableMap(nameToFrontEndMap);
    }

    @Override
    public LoadBalancerBackend backend() {
        return ((LoadBalancerImpl)this.parent()).backends().get(ResourceUtils.nameFromResourceId(((OutboundRuleInner)this.innerModel()).backendAddressPool().id()));
    }

    @Override
    public int allocatedOutboundPorts() {
        return ((OutboundRuleInner)this.innerModel()).allocatedOutboundPorts();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((OutboundRuleInner)this.innerModel()).provisioningState();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt(((OutboundRuleInner)this.innerModel()).idleTimeoutInMinutes());
    }

    @Override
    public boolean tcpResetEnabled() {
        return ((OutboundRuleInner)this.innerModel()).enableTcpReset();
    }

    @Override
    public String name() {
        return ((OutboundRuleInner)this.innerModel()).name();
    }

    @Override
    public LoadBalancerOutboundRuleImpl withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        ((OutboundRuleInner)this.innerModel()).withProtocol(protocol);
        return this;
    }

    public LoadBalancerOutboundRuleImpl fromBackend(String name) {
        ((LoadBalancerImpl)this.parent()).defineBackend(name).attach();
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + name);
        ((OutboundRuleInner)this.innerModel()).withBackendAddressPool(backendRef);
        return this;
    }

    public LoadBalancerOutboundRuleImpl toFrontend(String name) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(name);
        if (frontendRef != null) {
            ((OutboundRuleInner)this.innerModel()).withFrontendIpConfigurations(Arrays.asList(frontendRef));
        }
        return this;
    }

    public LoadBalancerOutboundRuleImpl toFrontends(List<String> names) {
        ArrayList<SubResource> frontendRefs = new ArrayList<SubResource>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(name);
                frontendRefs.add(frontendRef);
            }
        }
        ((OutboundRuleInner)this.innerModel()).withFrontendIpConfigurations(frontendRefs);
        return this;
    }

    public LoadBalancerOutboundRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((OutboundRuleInner)this.innerModel()).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    public LoadBalancerOutboundRuleImpl withEnableTcpReset(boolean enableTcpReset) {
        ((OutboundRuleInner)this.innerModel()).withEnableTcpReset(enableTcpReset);
        return this;
    }

    @Override
    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withOutboundRule(this);
    }
}

