/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpAddressAvailabilityResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkPeeringsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.SubnetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DdosProtectionPlan;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DhcpOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeerings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class NetworkImpl
extends GroupableParentResourceWithTagsImpl<Network, VirtualNetworkInner, NetworkImpl, NetworkManager>
implements Network,
Network.Definition,
Network.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private Map<String, Subnet> subnets;
    private NetworkPeeringsImpl peerings;
    private Creatable<DdosProtectionPlan> ddosProtectionPlanCreatable;

    NetworkImpl(String name, VirtualNetworkInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    protected void initializeChildrenFromInner() {
        this.subnets = new TreeMap<String, Subnet>();
        List<SubnetInner> inners = ((VirtualNetworkInner)this.innerModel()).subnets();
        if (inners != null) {
            for (SubnetInner inner : inners) {
                SubnetImpl subnet = new SubnetImpl(inner, this);
                this.subnets.put(inner.name(), subnet);
            }
        }
        this.peerings = new NetworkPeeringsImpl(this);
    }

    @Override
    public Mono<Network> refreshAsync() {
        return super.refreshAsync().map(network -> {
            NetworkImpl impl = (NetworkImpl)network;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<VirtualNetworkInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworks().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<VirtualNetworkInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworks().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((VirtualNetworkInner)this.innerModel()).tags()));
    }

    @Override
    public boolean isPrivateIPAddressAvailable(String ipAddress) {
        IpAddressAvailabilityResultInner result = this.checkIPAvailability(ipAddress);
        return result != null ? result.available() : false;
    }

    @Override
    public boolean isPrivateIPAddressInNetwork(String ipAddress) {
        IpAddressAvailabilityResultInner result = this.checkIPAvailability(ipAddress);
        return result != null;
    }

    private IpAddressAvailabilityResultInner checkIPAvailability(String ipAddress) {
        IpAddressAvailabilityResultInner result;
        block3: {
            if (ipAddress == null) {
                return null;
            }
            result = null;
            try {
                result = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworks().checkIpAddressAvailability(this.resourceGroupName(), this.name(), ipAddress);
            }
            catch (ManagementException e) {
                if (e.getValue().getCode().equalsIgnoreCase("PrivateIPAddressNotInAnySubnet")) break block3;
                throw this.logger.logExceptionAsError(e);
            }
        }
        return result;
    }

    NetworkImpl withSubnet(SubnetImpl subnet) {
        this.subnets.put(subnet.name(), subnet);
        return this;
    }

    @Override
    public NetworkImpl withDnsServer(String ipAddress) {
        if (((VirtualNetworkInner)this.innerModel()).dhcpOptions() == null) {
            ((VirtualNetworkInner)this.innerModel()).withDhcpOptions(new DhcpOptions());
        }
        if (((VirtualNetworkInner)this.innerModel()).dhcpOptions().dnsServers() == null) {
            ((VirtualNetworkInner)this.innerModel()).dhcpOptions().withDnsServers(new ArrayList<String>());
        }
        ((VirtualNetworkInner)this.innerModel()).dhcpOptions().dnsServers().add(ipAddress);
        return this;
    }

    @Override
    public NetworkImpl withSubnet(String name, String cidr) {
        return this.defineSubnet(name).withAddressPrefix(cidr).attach();
    }

    @Override
    public NetworkImpl withSubnets(Map<String, String> nameCidrPairs) {
        this.subnets.clear();
        for (Map.Entry<String, String> pair : nameCidrPairs.entrySet()) {
            this.withSubnet(pair.getKey(), pair.getValue());
        }
        return this;
    }

    @Override
    public NetworkImpl withoutSubnet(String name) {
        this.subnets.remove(name);
        return this;
    }

    @Override
    public NetworkImpl withAddressSpace(String cidr) {
        if (((VirtualNetworkInner)this.innerModel()).addressSpace() == null) {
            ((VirtualNetworkInner)this.innerModel()).withAddressSpace(new AddressSpace());
        }
        if (((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes() == null) {
            ((VirtualNetworkInner)this.innerModel()).addressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes().add(cidr);
        return this;
    }

    public SubnetImpl defineSubnet(String name) {
        SubnetInner inner = new SubnetInner().withName(name);
        return new SubnetImpl(inner, this);
    }

    @Override
    public NetworkImpl withoutAddressSpace(String cidr) {
        if (cidr != null && ((VirtualNetworkInner)this.innerModel()).addressSpace() != null && ((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes() != null) {
            ((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes().remove(cidr);
        }
        return this;
    }

    @Override
    public List<String> addressSpaces() {
        ArrayList addressSpaces = new ArrayList();
        if (((VirtualNetworkInner)this.innerModel()).addressSpace() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        if (((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        return Collections.unmodifiableList(((VirtualNetworkInner)this.innerModel()).addressSpace().addressPrefixes());
    }

    @Override
    public List<String> dnsServerIPs() {
        ArrayList ips = new ArrayList();
        if (((VirtualNetworkInner)this.innerModel()).dhcpOptions() == null) {
            return Collections.unmodifiableList(ips);
        }
        if (((VirtualNetworkInner)this.innerModel()).dhcpOptions().dnsServers() == null) {
            return Collections.unmodifiableList(ips);
        }
        return ((VirtualNetworkInner)this.innerModel()).dhcpOptions().dnsServers();
    }

    @Override
    public Map<String, Subnet> subnets() {
        return Collections.unmodifiableMap(this.subnets);
    }

    @Override
    protected void beforeCreating() {
        if (this.addressSpaces().size() == 0) {
            this.withAddressSpace("10.0.0.0/16");
        }
        if (this.isInCreateMode() && this.subnets.size() == 0) {
            this.withSubnet("subnet1", this.addressSpaces().get(0));
        }
        ((VirtualNetworkInner)this.innerModel()).withSubnets(this.innersFromWrappers(this.subnets.values()));
    }

    @Override
    public SubnetImpl updateSubnet(String name) {
        return (SubnetImpl)this.subnets.get(name);
    }

    @Override
    protected Mono<VirtualNetworkInner> createInner() {
        if (this.ddosProtectionPlanCreatable != null && this.taskResult(this.ddosProtectionPlanCreatable.key()) != null) {
            DdosProtectionPlan ddosProtectionPlan = (DdosProtectionPlan)this.taskResult(this.ddosProtectionPlanCreatable.key());
            this.withExistingDdosProtectionPlan(ddosProtectionPlan.id());
        }
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworks().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkInner)this.innerModel()).map(virtualNetworkInner -> {
            this.ddosProtectionPlanCreatable = null;
            return virtualNetworkInner;
        });
    }

    @Override
    public NetworkPeerings peerings() {
        return this.peerings;
    }

    @Override
    public boolean isDdosProtectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkInner)this.innerModel()).enableDdosProtection());
    }

    @Override
    public boolean isVmProtectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkInner)this.innerModel()).enableVmProtection());
    }

    @Override
    public String ddosProtectionPlanId() {
        return ((VirtualNetworkInner)this.innerModel()).ddosProtectionPlan() == null ? null : ((VirtualNetworkInner)this.innerModel()).ddosProtectionPlan().id();
    }

    @Override
    public NetworkImpl withNewDdosProtectionPlan() {
        ((VirtualNetworkInner)this.innerModel()).withEnableDdosProtection(true);
        DdosProtectionPlan.DefinitionStages.WithGroup ddosProtectionPlanWithGroup = (DdosProtectionPlan.DefinitionStages.WithGroup)((DdosProtectionPlan.DefinitionStages.Blank)((NetworkManager)this.manager()).ddosProtectionPlans().define(((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName(this.name(), 20))).withRegion(this.region());
        this.ddosProtectionPlanCreatable = this.creatableGroup != null && this.isInCreateMode() ? (Creatable)ddosProtectionPlanWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)ddosProtectionPlanWithGroup.withExistingResourceGroup(this.resourceGroupName());
        this.addDependency(this.ddosProtectionPlanCreatable);
        return this;
    }

    @Override
    public NetworkImpl withExistingDdosProtectionPlan(String planId) {
        ((VirtualNetworkInner)this.innerModel()).withEnableDdosProtection(true).withDdosProtectionPlan(new SubResource().withId(planId));
        return this;
    }

    @Override
    public NetworkImpl withoutDdosProtectionPlan() {
        ((VirtualNetworkInner)this.innerModel()).withEnableDdosProtection(false).withDdosProtectionPlan(null);
        return this;
    }

    @Override
    public NetworkImpl withVmProtection() {
        ((VirtualNetworkInner)this.innerModel()).withEnableVmProtection(true);
        return this;
    }

    @Override
    public NetworkImpl withoutVmProtection() {
        ((VirtualNetworkInner)this.innerModel()).withEnableVmProtection(false);
        return this;
    }
}

