/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.VirtualNetworksClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DhcpOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Networks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import java.util.ArrayList;

public class NetworksImpl
extends TopLevelModifiableResourcesImpl<Network, NetworkImpl, VirtualNetworkInner, VirtualNetworksClient, NetworkManager>
implements Networks {
    public NetworksImpl(NetworkManager networkManager) {
        super(((NetworkManagementClient)networkManager.serviceClient()).getVirtualNetworks(), networkManager);
    }

    @Override
    public NetworkImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected NetworkImpl wrapModel(String name) {
        DhcpOptions dhcp;
        VirtualNetworkInner inner = new VirtualNetworkInner();
        AddressSpace addressSpace = inner.addressSpace();
        if (addressSpace == null) {
            addressSpace = new AddressSpace();
            inner.withAddressSpace(addressSpace);
        }
        if (addressSpace.addressPrefixes() == null) {
            addressSpace.withAddressPrefixes(new ArrayList<String>());
        }
        if (inner.subnets() == null) {
            inner.withSubnets(new ArrayList<SubnetInner>());
        }
        if ((dhcp = inner.dhcpOptions()) == null) {
            dhcp = new DhcpOptions();
            inner.withDhcpOptions(dhcp);
        }
        if (dhcp.dnsServers() == null) {
            dhcp.withDnsServers(new ArrayList<String>());
        }
        return new NetworkImpl(name, inner, (NetworkManager)super.manager());
    }

    @Override
    protected NetworkImpl wrapModel(VirtualNetworkInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

