/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityGroupViewResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkWatcher;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityGroupNetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityGroupView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityGroupViewParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class SecurityGroupViewImpl
extends RefreshableWrapperImpl<SecurityGroupViewResultInner, SecurityGroupView>
implements SecurityGroupView {
    private Map<String, SecurityGroupNetworkInterface> networkInterfaces;
    private final NetworkWatcherImpl parent;
    private final String vmId;

    SecurityGroupViewImpl(NetworkWatcherImpl parent, SecurityGroupViewResultInner innerObject, String vmId) {
        super(innerObject);
        this.parent = parent;
        this.vmId = vmId;
        this.initializeFromInner();
    }

    private void initializeFromInner() {
        this.networkInterfaces = new TreeMap<String, SecurityGroupNetworkInterface>();
        List<SecurityGroupNetworkInterface> securityGroupNetworkInterfaces = ((SecurityGroupViewResultInner)this.innerModel()).networkInterfaces();
        if (securityGroupNetworkInterfaces != null) {
            for (SecurityGroupNetworkInterface networkInterface : securityGroupNetworkInterfaces) {
                this.networkInterfaces.put(networkInterface.id(), networkInterface);
            }
        }
    }

    @Override
    public Map<String, SecurityGroupNetworkInterface> networkInterfaces() {
        return Collections.unmodifiableMap(this.networkInterfaces);
    }

    @Override
    public String vmId() {
        return this.vmId;
    }

    @Override
    public NetworkWatcher parent() {
        return this.parent;
    }

    @Override
    public Mono<SecurityGroupView> refreshAsync() {
        return super.refreshAsync().map(securityGroupView -> {
            SecurityGroupViewImpl impl = (SecurityGroupViewImpl)securityGroupView;
            impl.initializeFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<SecurityGroupViewResultInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().getVMSecurityRulesAsync(this.parent.resourceGroupName(), this.parent.name(), new SecurityGroupViewParameters().withTargetResourceId(this.vmId));
    }
}

